/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.token.opaque;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.token.AuthTokenInfo;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenHandler;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.auth.oauth.MetaClientPolicy;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.token.opaque.OAuthServiceHolder;
import org.iplass.mtp.impl.auth.oauth.token.opaque.OpaqueOAuthAccessTokenStore;
import org.iplass.mtp.impl.auth.oauth.token.opaque.RefreshTokenMement;
import org.iplass.mtp.spi.Config;

class RefreshTokenHandler
extends AuthTokenHandler {
    RefreshTokenHandler() {
    }

    public void inited(AuthTokenService service, Config config) {
        super.inited(service, config);
    }

    public AuthTokenInfo toAuthTokenInfo(AuthToken authToken) {
        RefreshTokenMement.RefreshTokenInfo info = new RefreshTokenMement.RefreshTokenInfo();
        info.setType(this.getType());
        info.setKey(authToken.getSeries());
        ((RefreshTokenMement)authToken.getDetails()).fill(info);
        return info;
    }

    public Credential toCredential(AuthToken newToken) {
        return null;
    }

    protected Serializable createDetails(String seriesString, String tokenString, String userUniqueId, String policyName, AuthTokenInfo tokenInfo) {
        RefreshTokenMement mement = new RefreshTokenMement();
        RefreshTokenMement.RefreshTokenInfo info = (RefreshTokenMement.RefreshTokenInfo)tokenInfo;
        MetaOAuthClient.OAuthClientRuntime client = (MetaOAuthClient.OAuthClientRuntime)OAuthServiceHolder.client.getRuntimeByName(info.getClientName());
        MetaOAuthAuthorization.OAuthAuthorizationRuntime server = client.getAuthorizationServer();
        MetaClientPolicy.ClientPolicyRuntime cp = server.getClientPolicy(client.getMetaData().getClientType());
        long expires = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(cp.getMetaData().getRefreshTokenLifetimeSeconds());
        mement.save(info, expires, userUniqueId);
        return mement;
    }

    public String newSeriesString(String userUniqueId, String policyName, AuthTokenInfo tokenInfo) {
        RefreshTokenMement.RefreshTokenInfo ati = (RefreshTokenMement.RefreshTokenInfo)tokenInfo;
        MetaOAuthClient.OAuthClientRuntime clientRuntime = (MetaOAuthClient.OAuthClientRuntime)OAuthServiceHolder.client.getRuntimeByName(ati.getClientName());
        return ((OpaqueOAuthAccessTokenStore)OAuthServiceHolder.authorization.getAccessTokenStore()).toSeriesString(clientRuntime, userUniqueId);
    }
}

