/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.token.opaque;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.oauth.AccessTokenInfo;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.token.opaque.OAuthServiceHolder;

class AccessTokenMement
implements Serializable {
    private static final long serialVersionUID = -7300870311238433196L;
    private String clientMetaDataId;
    private List<String> grantedScopes;
    private long expires;
    private String resouceOwnerId;
    private User user;
    private transient AuthToken refreshToken;

    AccessTokenMement() {
    }

    void save(AccessTokenInfo info, long expires, String resouceOwnerId, User user) {
        MetaOAuthClient.OAuthClientRuntime client = (MetaOAuthClient.OAuthClientRuntime)OAuthServiceHolder.client.getRuntimeByName(info.getClientName());
        this.clientMetaDataId = client.getMetaData().getId();
        if (info.getGrantedScopes() != null) {
            this.grantedScopes = new ArrayList<String>(info.getGrantedScopes());
        }
        this.expires = expires;
        this.resouceOwnerId = resouceOwnerId;
        this.user = user;
    }

    void fill(AccessTokenInfo info) {
        MetaOAuthClient.OAuthClientRuntime ocr = (MetaOAuthClient.OAuthClientRuntime)OAuthServiceHolder.client.getRuntimeById(this.clientMetaDataId);
        if (ocr != null) {
            info.setClientName(ocr.getMetaData().getName());
        }
        if (this.grantedScopes != null) {
            info.setGrantedScopes(new ArrayList<String>(this.grantedScopes));
        }
    }

    public AuthToken getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(AuthToken refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getClientMetaDataId() {
        return this.clientMetaDataId;
    }

    long getExpires() {
        return this.expires;
    }

    public String getResouceOwnerId() {
        return this.resouceOwnerId;
    }

    User getUser() {
        return this.user;
    }

    List<String> getGrantedScopes() {
        return this.grantedScopes;
    }
}

