/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.jwt;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.iplass.mtp.impl.auth.oauth.jwt.CertificateKeyPair;
import org.iplass.mtp.impl.auth.oauth.jwt.SimpleJwtKeyStore;

public enum JwtKeyRolloverType {
    OLDER{

        @Override
        CertificateKeyPair select(SimpleJwtKeyStore jwtKeyStore) {
            CertificateKeyPair candidate = null;
            for (CertificateKeyPair pair : jwtKeyStore.list()) {
                try {
                    pair.getCertificate().checkValidity();
                    if (candidate != null && candidate.getCertificate().getNotAfter().getTime() <= pair.getCertificate().getNotAfter().getTime()) continue;
                    candidate = pair;
                }
                catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {}
            }
            return candidate;
        }
    }
    ,
    BEFORE_N_DAYS{

        @Override
        CertificateKeyPair select(SimpleJwtKeyStore jwtKeyStore) {
            CertificateKeyPair candidateOldest = null;
            CertificateKeyPair candidateNewest = null;
            for (CertificateKeyPair pair : jwtKeyStore.list()) {
                try {
                    pair.getCertificate().checkValidity();
                    if (candidateOldest == null || candidateOldest.getCertificate().getNotAfter().getTime() > pair.getCertificate().getNotAfter().getTime()) {
                        candidateOldest = pair;
                    }
                    if (candidateNewest != null && candidateNewest.getCertificate().getNotAfter().getTime() >= pair.getCertificate().getNotAfter().getTime()) continue;
                    candidateNewest = pair;
                }
                catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {}
            }
            CertificateKeyPair candidate = null;
            if (candidateOldest == candidateNewest) {
                candidate = candidateOldest;
            } else if (candidateOldest != null) {
                Instant now = Instant.now();
                Date nowPlus = new Date(now.plus(jwtKeyStore.getRollOverDaysBeforeExpire(), ChronoUnit.DAYS).toEpochMilli());
                try {
                    candidateOldest.getCertificate().checkValidity(nowPlus);
                    candidate = candidateOldest;
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    candidate = candidateNewest;
                }
            }
            return candidate;
        }
    }
    ,
    NEWER{

        @Override
        CertificateKeyPair select(SimpleJwtKeyStore jwtKeyStore) {
            CertificateKeyPair candidate = null;
            for (CertificateKeyPair pair : jwtKeyStore.list()) {
                try {
                    pair.getCertificate().checkValidity();
                    if (candidate != null && candidate.getCertificate().getNotAfter().getTime() >= pair.getCertificate().getNotAfter().getTime()) continue;
                    candidate = pair;
                }
                catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {}
            }
            return candidate;
        }
    };


    abstract CertificateKeyPair select(SimpleJwtKeyStore var1);
}

