/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.Variant;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.session.SessionService;
import org.iplass.mtp.impl.web.RequestPath;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.webapi.MetaWebApi;
import org.iplass.mtp.impl.webapi.WebApiParameter;
import org.iplass.mtp.impl.webapi.WebApiParameterMap;
import org.iplass.mtp.impl.webapi.WebApiResponse;
import org.iplass.mtp.impl.webapi.WebApiService;
import org.iplass.mtp.impl.webapi.jackson.WebApiObjectMapperService;
import org.iplass.mtp.impl.webapi.jaxb.WebApiJaxbService;
import org.iplass.mtp.impl.webapi.rest.MapParameterValueMap;
import org.iplass.mtp.impl.webapi.rest.MultivaluedMapParameterValueMap;
import org.iplass.mtp.impl.webapi.rest.RestRequestContext;
import org.iplass.mtp.impl.webapi.rest.WrappedRestException;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.webapi.WebApiRuntimeException;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.iplass.mtp.webapi.definition.StateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Path(value="/")
public class RestCommandInvoker {
    private static final String ORIGIN = "Origin";
    private static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static Logger logger = LoggerFactory.getLogger(RestCommandInvoker.class);
    private static WebApiJaxbService jbservice = (WebApiJaxbService)ServiceRegistry.getRegistry().getService(WebApiJaxbService.class);
    private static WebApiObjectMapperService omservice = (WebApiObjectMapperService)ServiceRegistry.getRegistry().getService(WebApiObjectMapperService.class);
    private static WebApiService apiservice = (WebApiService)ServiceRegistry.getRegistry().getService(WebApiService.class);
    private static SessionService sessionService = (SessionService)ServiceRegistry.getRegistry().getService(SessionService.class);
    @Context
    SAXParserFactory sax;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R process(String apiName, String httpMethod, ServletContext servletContext, Request rsRequest, HttpServletRequest request, HttpServletResponse response, BiFunction<WebRequestStack, MetaWebApi.WebApiRuntime, R> func) {
        RequestPath path = new RequestPath(apiName, (RequestPath)request.getAttribute("mtp.requestPath"));
        request.removeAttribute("mtp.requestPath");
        String webApiName = path.getTargetPath(true);
        MetaWebApi.WebApiRuntime runtime = apiservice.getByPathHierarchy(webApiName, httpMethod);
        if (runtime == null) {
            if (logger.isDebugEnabled()) {
                logger.debug(webApiName + " not defined path.");
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        RestRequestContext context = new RestRequestContext(servletContext, request, rsRequest, runtime.getMetaData().isSupportBearerToken());
        WebRequestStack stack = new WebRequestStack(path, context, servletContext, request, response, null);
        if (runtime.getMetaData().getState() == StateType.STATELESS) {
            sessionService.setSessionStateless(false);
        }
        try {
            stack.setAttribute("webApiName", runtime.getPublicWebApiName());
            R r = func.apply(stack, runtime);
            return r;
        }
        finally {
            stack.finallyProcess();
        }
    }

    private Response executeCommand(WebRequestStack stack, MetaWebApi.WebApiRuntime runtime) {
        Response.ResponseBuilder rb;
        WebApiResponse result = new WebApiResponse();
        try {
            result.setStatus(runtime.executeCommand(stack.getRequestContext(), "webApi"));
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new WrappedRestException(e);
        }
        Object onlyOneRes = null;
        if (runtime.getMetaData().getResults() != null) {
            for (String name : runtime.getMetaData().getResults()) {
                Object val = stack.getRequestContext().getAttribute(name);
                if (val == null) continue;
                result.addResult(name, val);
            }
        }
        if (result.getResults() != null && result.getResults().size() == 1) {
            onlyOneRes = result.getResults().values().iterator().next();
        }
        if (runtime.getMetaData().getCacheControlType() != null) {
            switch (runtime.getMetaData().getCacheControlType()) {
                case CACHE: {
                    WebUtil.setCacheControlHeader(stack, true, runtime.getMetaData().getCacheControlMaxAge());
                    break;
                }
                case NO_CACHE: {
                    WebUtil.setCacheControlHeader(stack, false, -1L);
                    break;
                }
            }
        }
        if (onlyOneRes instanceof Response.ResponseBuilder) {
            return ((Response.ResponseBuilder)onlyOneRes).build();
        }
        if (onlyOneRes instanceof StreamingOutput) {
            rb = Response.ok((Object)onlyOneRes);
            rb.type(this.selectVariant(stack, runtime).getMediaType());
            return rb.build();
        }
        rb = Response.ok((Object)result);
        rb.type(this.selectVariant(stack, runtime).getMediaType());
        return rb.build();
    }

    private Variant selectVariant(WebRequestStack stack, MetaWebApi.WebApiRuntime runtime) {
        List<Variant> variants = runtime.getVariants();
        if (variants.size() == 1) {
            return variants.get(0);
        }
        RestRequestContext context = (RestRequestContext)stack.getRequestContext();
        Variant v = context.rsRequest().selectVariant(variants);
        if (v == null) {
            throw new WebApiRuntimeException("Response Type cannot determined. Specify correct Accept header:" + stack.getRequest().getHeader("Accept"));
        }
        return v;
    }

    private void checkValidRequest(WebRequestStack stack, MetaWebApi.WebApiRuntime runtime) {
        RestRequestContext context = (RestRequestContext)stack.getRequestContext();
        runtime.checkMethodType(context.methodType());
        runtime.checkRequestType(context.requestType(), stack.getRequest());
        if (!this.handleCrossOriginResourceSharing(runtime, context, stack.getRequest(), stack.getResponse())) {
            throw new WebApiRuntimeException("Cross Origin Resource Sharing Policy Erorr on WebApi:" + runtime.getMetaData().getName());
        }
        runtime.checkXRequestedWith(stack.getRequest());
    }

    private boolean isSameOrigin(String requestOrigin, HttpServletRequest request) {
        URI originUri;
        try {
            originUri = new URI(requestOrigin);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("requestOrigin not valid:" + requestOrigin, e);
        }
        if (!originUri.getHost().equals(request.getServerName())) {
            return false;
        }
        int port = originUri.getPort();
        if (port == -1) {
            if ("http".equals(originUri.getScheme())) {
                port = 80;
            } else if ("https".equals(originUri.getScheme())) {
                port = 443;
            }
        }
        return port == request.getServerPort();
    }

    private boolean handleCrossOriginResourceSharing(MetaWebApi.WebApiRuntime runtime, RequestContext context, HttpServletRequest request, HttpServletResponse response) {
        String requestOrigin = request.getHeader(ORIGIN);
        if (requestOrigin == null) {
            return true;
        }
        if (this.isSameOrigin(requestOrigin, request)) {
            return true;
        }
        boolean allowOrigin = runtime.isCorsAllowOrigin(requestOrigin, context);
        if (logger.isDebugEnabled()) {
            logger.debug("CORS check with Origin: " + requestOrigin + ", api: " + runtime.getMetaData().getName() + " = " + allowOrigin);
        }
        if (allowOrigin) {
            response.addHeader(ACCESS_CONTROL_ALLOW_ORIGIN, requestOrigin);
            if (runtime.isCorsAllowCredentials()) {
                response.addHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
            }
            if (request.getMethod().equals("OPTIONS")) {
                String accessControlRequestHeaders;
                String accessControlRequestMethod = request.getHeader(ACCESS_CONTROL_REQUEST_METHOD);
                if (accessControlRequestMethod != null) {
                    response.addHeader(ACCESS_CONTROL_ALLOW_METHODS, accessControlRequestMethod);
                }
                if ((accessControlRequestHeaders = request.getHeader(ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
                    response.addHeader(ACCESS_CONTROL_ALLOW_HEADERS, accessControlRequestHeaders);
                }
            }
        }
        return allowOrigin;
    }

    private RequestType decideRequestType(HttpServletRequest request, MetaWebApi.WebApiRuntime runtime) {
        MediaType mt;
        RequestType type = null;
        String contentType = request.getContentType();
        if (contentType != null && (mt = MediaType.valueOf((String)contentType)).getType().equals(MediaType.APPLICATION_JSON_TYPE.getType())) {
            if (mt.getSubtype().equals(MediaType.APPLICATION_JSON_TYPE.getSubtype())) {
                type = RequestType.REST_JSON;
            } else if (mt.getSubtype().equals(MediaType.APPLICATION_XML_TYPE.getSubtype())) {
                type = RequestType.REST_XML;
            }
        }
        if (type == null && runtime.getMetaData().getAccepts() != null && runtime.getMetaData().getAccepts().length == 1) {
            type = runtime.getMetaData().getAccepts()[0];
        }
        if (type == null) {
            type = RequestType.REST_FORM;
        }
        return type;
    }

    @OPTIONS
    @Path(value="{apiName : .+}")
    public Response preflight(@Context ServletContext servletContext, @Context Request rsRequest, @Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="apiName") String apiName) {
        String accessControlRequestMethod = request.getHeader(ACCESS_CONTROL_REQUEST_METHOD);
        return this.process(apiName, accessControlRequestMethod, servletContext, rsRequest, request, response, (stack, runtime) -> {
            this.handleCrossOriginResourceSharing((MetaWebApi.WebApiRuntime)((Object)runtime), stack.getRequestContext(), request, response);
            Response.ResponseBuilder rb = Response.ok();
            return rb.build();
        });
    }

    @GET
    @Path(value="{apiName : .+}")
    public Response doGet(@Context ServletContext servletContext, @Context Request coreRequest, @Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="apiName") String apiName) {
        return this.process(apiName, "GET", servletContext, coreRequest, request, response, (stack, runtime) -> {
            RestRequestContext rs = (RestRequestContext)stack.getRequestContext();
            RequestType type = this.decideRequestType(request, (MetaWebApi.WebApiRuntime)((Object)runtime));
            rs.setRequestType(type);
            this.checkValidRequest((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
            switch (type) {
                case REST_JSON: {
                    this.setJsonParameter((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime), request, null);
                    break;
                }
                case REST_XML: {
                    this.setXmlParameter((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime), request, null);
                    break;
                }
            }
            return this.executeCommand((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
        });
    }

    @DELETE
    @Path(value="{apiName : .+}")
    public Response doDelete(@Context ServletContext servletContext, @Context Request coreRequest, @Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="apiName") String apiName) {
        return this.process(apiName, "DELETE", servletContext, coreRequest, request, response, (stack, runtime) -> {
            RestRequestContext rs = (RestRequestContext)stack.getRequestContext();
            RequestType type = this.decideRequestType(request, (MetaWebApi.WebApiRuntime)((Object)runtime));
            rs.setRequestType(type);
            this.checkValidRequest((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
            switch (type) {
                case REST_JSON: {
                    this.setJsonParameter((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime), request, null);
                    break;
                }
                case REST_XML: {
                    this.setXmlParameter((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime), request, null);
                    break;
                }
            }
            return this.executeCommand((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
        });
    }

    @PUT
    @Path(value="{apiName : .+}")
    @Consumes(value={"application/x-www-form-urlencoded", "*/*"})
    public Response doPutForm(@Context ServletContext servletContext, @Context Request coreRequest, @Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="apiName") String apiName, MultivaluedMap<String, String> params) {
        return this.process(apiName, "PUT", servletContext, coreRequest, request, response, (stack, runtime) -> {
            RestRequestContext rc = (RestRequestContext)stack.getRequestContext();
            rc.setRequestType(RequestType.REST_FORM);
            rc.setValueMap(new MultivaluedMapParameterValueMap(params));
            this.checkValidRequest((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
            return this.executeCommand((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
        });
    }

    @PUT
    @Path(value="{apiName : .+}")
    @Consumes(value={"application/json"})
    public Response doPutJson(@Context ServletContext servletContext, @Context Request coreRequest, @Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="apiName") String apiName, Reader reader) {
        return this.process(apiName, "PUT", servletContext, coreRequest, request, response, (stack, runtime) -> {
            RestRequestContext rs = (RestRequestContext)stack.getRequestContext();
            rs.setRequestType(RequestType.REST_JSON);
            this.checkValidRequest((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
            this.setJsonParameter((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime), request, reader);
            return this.executeCommand((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
        });
    }

    @PUT
    @Path(value="{apiName : .+}")
    @Consumes(value={"application/xml"})
    public Response doPutXml(@Context ServletContext servletContext, @Context Request coreRequest, @Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="apiName") String apiName, Reader reader) {
        return this.process(apiName, "PUT", servletContext, coreRequest, request, response, (stack, runtime) -> {
            RestRequestContext rs = (RestRequestContext)stack.getRequestContext();
            rs.setRequestType(RequestType.REST_XML);
            this.checkValidRequest((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
            this.setXmlParameter((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime), request, reader);
            return this.executeCommand((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
        });
    }

    @POST
    @Path(value="{apiName : .+}")
    @Consumes(value={"application/x-www-form-urlencoded", "*/*"})
    public Response doPostForm(@Context ServletContext servletContext, @Context Request coreRequest, @Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="apiName") String apiName, MultivaluedMap<String, String> params) {
        return this.process(apiName, "POST", servletContext, coreRequest, request, response, (stack, runtime) -> {
            RestRequestContext rc = (RestRequestContext)stack.getRequestContext();
            rc.setRequestType(RequestType.REST_FORM);
            rc.setValueMap(new MultivaluedMapParameterValueMap(params));
            this.checkValidRequest((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
            return this.executeCommand((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
        });
    }

    @POST
    @Path(value="{apiName : .+}")
    @Consumes(value={"multipart/form-data"})
    public Response doPostFormMultipart(@Context ServletContext servletContext, @Context Request coreRequest, @Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="apiName") String apiName) {
        return this.process(apiName, "POST", servletContext, coreRequest, request, response, (stack, runtime) -> {
            ((RestRequestContext)stack.getRequestContext()).setRequestType(RequestType.REST_FORM);
            this.checkValidRequest((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
            return this.executeCommand((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
        });
    }

    @POST
    @Path(value="{apiName : .+}")
    @Consumes(value={"application/json"})
    public Response doPostJson(@Context ServletContext servletContext, @Context Request coreRequest, @Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="apiName") String apiName, Reader reader) {
        return this.process(apiName, "POST", servletContext, coreRequest, request, response, (stack, runtime) -> {
            RestRequestContext rs = (RestRequestContext)stack.getRequestContext();
            rs.setRequestType(RequestType.REST_JSON);
            this.checkValidRequest((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
            this.setJsonParameter((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime), request, reader);
            return this.executeCommand((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
        });
    }

    @POST
    @Path(value="{apiName : .+}")
    @Consumes(value={"application/xml"})
    public Response doPostXml(@Context ServletContext servletContext, @Context Request coreRequest, @Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="apiName") String apiName, Reader reader) {
        return this.process(apiName, "POST", servletContext, coreRequest, request, response, (stack, runtime) -> {
            RestRequestContext rs = (RestRequestContext)stack.getRequestContext();
            rs.setRequestType(RequestType.REST_XML);
            this.checkValidRequest((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
            this.setXmlParameter((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime), request, reader);
            return this.executeCommand((WebRequestStack)stack, (MetaWebApi.WebApiRuntime)((Object)runtime));
        });
    }

    private void setJsonParameter(WebRequestStack stack, MetaWebApi.WebApiRuntime runtime, HttpServletRequest request, Reader reader) {
        RestRequestContext context = (RestRequestContext)stack.getRequestContext();
        MethodType methodType = context.methodType();
        try {
            String paramName = runtime.getMetaData().getRestJsonParameterName();
            if (paramName != null) {
                ObjectMapper mapper = omservice.getObjectMapper();
                Map<String, Object> o = null;
                Class<Object> type = runtime.getMetaData().getRestJsonParameterType();
                if (type == null || type == Void.TYPE) {
                    type = Object.class;
                }
                if (MethodType.GET == methodType || MethodType.DELETE == methodType) {
                    String paramStr = request.getParameter(paramName);
                    if (paramStr != null) {
                        o = mapper.readValue(paramStr, type);
                    }
                } else {
                    o = mapper.readValue(reader, type);
                }
                if (o instanceof WebApiParameterMap) {
                    o = this.toMap((WebApiParameterMap)((Object)o));
                }
                if (paramName.equals("param") && o instanceof Map) {
                    context.setValueMap(new MapParameterValueMap(o));
                } else if (o != null) {
                    context.setAttribute(paramName, o);
                }
            }
        }
        catch (IOException | NullPointerException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    private Map<String, Object> toMap(WebApiParameterMap m) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (WebApiParameter webApiParameter : m.getParams()) {
            map.put(webApiParameter.getName(), webApiParameter.getValue());
        }
        return map;
    }

    private void setXmlParameter(WebRequestStack stack, MetaWebApi.WebApiRuntime runtime, HttpServletRequest request, Reader reader) {
        RestRequestContext context = (RestRequestContext)stack.getRequestContext();
        MethodType methodType = context.methodType();
        try {
            String paramName = runtime.getMetaData().getRestXmlParameterName();
            if (paramName != null) {
                Object o;
                if (MethodType.GET == methodType || MethodType.DELETE == methodType) {
                    String param = request.getParameter(paramName);
                    if (StringUtil.isEmpty((String)param)) {
                        o = null;
                    } else {
                        ByteArrayInputStream bais = new ByteArrayInputStream(param.getBytes());
                        JAXBContext jaxb = jbservice.getJAXBContext();
                        o = jaxb.createUnmarshaller().unmarshal((Source)new SAXSource(this.sax.newSAXParser().getXMLReader(), new InputSource(bais)));
                    }
                } else {
                    JAXBContext jaxb = jbservice.getJAXBContext();
                    o = jaxb.createUnmarshaller().unmarshal((Source)new SAXSource(this.sax.newSAXParser().getXMLReader(), new InputSource(reader)));
                }
                if (o instanceof WebApiParameterMap) {
                    o = this.toMap((WebApiParameterMap)o);
                }
                if (paramName.equals("param") && o instanceof Map) {
                    context.setValueMap(new MapParameterValueMap((Map)o));
                } else if (o != null) {
                    context.setAttribute(paramName, o);
                }
            }
        }
        catch (NullPointerException | JAXBException | ParserConfigurationException | SAXException e) {
            throw new WebApplicationException(e, Response.Status.BAD_REQUEST);
        }
    }
}

