/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.webapi.jackson.MixinConfig;
import org.iplass.mtp.impl.webapi.jackson.WebApiParameterType;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;

public class WebApiObjectMapperService
implements Service {
    private ObjectMapper mapper;
    private Map<String, Class<?>> typeMap;
    private List<MixinConfig> mixin;
    private boolean writeNullMapValues = false;
    private boolean writeNullValues = false;
    private boolean escapeNonAscii = false;

    public List<MixinConfig> getMixin() {
        return this.mixin;
    }

    public boolean isEscapeNonAscii() {
        return this.escapeNonAscii;
    }

    public boolean isWriteNullValues() {
        return this.writeNullValues;
    }

    public boolean isWriteNullMapValues() {
        return this.writeNullMapValues;
    }

    public void init(Config config) {
        if (config.getValue("writeNullValues") != null) {
            this.writeNullValues = Boolean.valueOf(config.getValue("writeNullValues"));
        }
        if (config.getValue("writeNullMapValues") != null) {
            this.writeNullMapValues = Boolean.valueOf(config.getValue("writeNullMapValues"));
        }
        if (config.getValue("escapeNonAscii") != null) {
            this.escapeNonAscii = Boolean.valueOf(config.getValue("escapeNonAscii"));
        }
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        if (this.escapeNonAscii) {
            this.mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
        }
        if (this.writeNullValues) {
            this.mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        } else {
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        if (this.writeNullMapValues) {
            this.mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, true);
        } else {
            this.mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        }
        this.mixin = config.getValues("mixin", MixinConfig.class);
        if (this.mixin != null && this.mixin.size() > 0) {
            for (MixinConfig mc : this.mixin) {
                this.mapper.addMixIn(mc.getTarget(), mc.getMixinSource());
            }
        }
        this.typeMap = new HashMap();
        List typeList = config.getValues("parameterType", WebApiParameterType.class);
        if (typeList != null && typeList.size() > 0) {
            for (WebApiParameterType t : typeList) {
                try {
                    this.typeMap.put(t.getTypeName(), Class.forName(t.getClassName()));
                }
                catch (ClassNotFoundException e) {
                    throw new ServiceConfigrationException("cant find Class of WebApiParameterType:" + t.getClassName(), (Throwable)e);
                }
            }
        }
    }

    public void destroy() {
        this.mapper = null;
        this.typeMap = null;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public Class<?> getMappedClass(String type) {
        return this.typeMap.get(type);
    }
}

