/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.command.entity;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.StreamingOutput;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.impl.entity.csv.EntitySearchCsvWriter;
import org.iplass.mtp.impl.entity.csv.EntityWriteOption;
import org.iplass.mtp.impl.entity.csv.QueryCsvWriter;
import org.iplass.mtp.impl.webapi.command.entity.AbstractEntityCommand;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="mtp/entity/GET", accepts={RequestType.REST_FORM}, methods={MethodType.GET}, results={"list", "count", "entity", "csv"}, responseType="application/json, application/xml, text/csv;charset=utf-8", overwritable=false)
@CommandClass(name="mtp/entity/GetEntityCommand", displayName="Entity Query/Load Web API", overwritable=false)
public final class GetEntityCommand
extends AbstractEntityCommand {
    public static final String PARAM_QUERY = "query";
    public static final String PARAM_TABLE_MODE = "tabular";
    public static final String PARAM_COUNT_TOTAL = "countTotal";
    public static final String PARAM_FILTER = "filter";
    public static final String RESULT_ENTITY_LIST = "list";
    public static final String RESULT_COUNT = "count";
    public static final String RESULT_ENTITY = "entity";
    public static final String RESULT_CSV = "csv";

    private void query(RequestContext request) {
        String eql = request.getParam(PARAM_QUERY);
        if (eql == null) {
            throw new NullPointerException("query must specify");
        }
        Query query = Query.newQuery((String)eql);
        boolean isCSV = this.isCSV(request);
        if (!isCSV) {
            this.queryImpl(query, request);
        } else {
            this.queryCsv(query, request);
        }
    }

    private void list(String entityDef, RequestContext request) {
        boolean isCSV;
        Query query = new Query().selectAll(entityDef, false, true);
        String filter = request.getParam(PARAM_FILTER);
        if (filter != null) {
            query.where(filter);
        }
        if (!(isCSV = this.isCSV(request))) {
            this.queryImpl(query, request);
        } else {
            this.listCsv(query, request);
        }
    }

    private void queryImpl(Query query, RequestContext request) {
        this.checkPermission(query.getFrom().getEntityName(), def -> def.getMetaData().isQuery());
        if (query.getLimit() == null) {
            query.limit(this.entityWebApiService.getMaxLimit());
        }
        if (query.getLimit().getLimit() > this.entityWebApiService.getMaxLimit()) {
            throw new IllegalArgumentException("Can not specify limit more than " + this.entityWebApiService.getMaxLimit());
        }
        boolean tabular = (Boolean)request.getParam(PARAM_TABLE_MODE, Boolean.class, (Object)false);
        boolean countTotal = (Boolean)request.getParam(PARAM_COUNT_TOTAL, Boolean.class, (Object)false);
        SearchOption option = new SearchOption();
        if (!tabular) {
            option.setReturnStructuredEntity(true);
        }
        if (countTotal) {
            option.setCountTotal(true);
        }
        SearchResult res = tabular ? this.em.search(query, option) : this.em.searchEntity(query, option);
        request.setAttribute(RESULT_ENTITY_LIST, (Object)res.getList());
        if (countTotal) {
            request.setAttribute(RESULT_COUNT, (Object)res.getTotalCount());
        }
    }

    private void queryCsv(Query query, RequestContext request) {
        this.checkPermission(query.getFrom().getEntityName(), def -> def.getMetaData().isQuery());
        StreamingOutput stream = out -> {
            try (QueryCsvWriter writer = new QueryCsvWriter(out, query);){
                writer.write();
            }
        };
        request.setAttribute(RESULT_CSV, (Object)stream);
    }

    private void listCsv(Query query, RequestContext request) {
        this.checkPermission(query.getFrom().getEntityName(), def -> def.getMetaData().isQuery());
        StreamingOutput stream = out -> {
            EntityWriteOption option = new EntityWriteOption().where(query.getWhere()).orderBy(query.getOrderBy());
            try (EntitySearchCsvWriter writer = new EntitySearchCsvWriter(out, query.getFrom().getEntityName(), option);){
                writer.write();
            }
        };
        request.setAttribute(RESULT_CSV, (Object)stream);
    }

    private boolean isCSV(RequestContext request) {
        String accept = ((HttpServletRequest)request.getAttribute("servletRequest")).getHeader("Accept");
        return accept != null && accept.startsWith("text/csv");
    }

    private void load(String entityDef, String oid, String ver, RequestContext request) {
        Entity e;
        this.checkPermission(entityDef, def -> def.getMetaData().isLoad());
        Long version = null;
        if (ver != null) {
            version = Long.parseLong(ver);
        }
        if ((e = this.em.load(oid, version, entityDef, new LoadOption(true, false))) != null) {
            request.setAttribute(RESULT_ENTITY, (Object)e);
        }
    }

    @Override
    public String executeImpl(RequestContext request, String[] subPath) {
        if (subPath == null || subPath.length == 0) {
            this.query(request);
        } else {
            switch (subPath.length) {
                case 1: {
                    this.list(subPath[0], request);
                    break;
                }
                case 2: {
                    this.load(subPath[0], subPath[1], null, request);
                    break;
                }
                case 3: {
                    this.load(subPath[0], subPath[1], subPath[2], request);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal path parameter:" + subPath);
                }
            }
        }
        return "SUCCESS";
    }
}

