/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.report.ReportingEngine;
import org.iplass.mtp.impl.report.ReportingEngineService;
import org.iplass.mtp.impl.report.ReportingOutputModel;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.template.MetaTemplate;
import org.iplass.mtp.impl.web.template.TemplateRuntimeException;
import org.iplass.mtp.impl.web.template.report.MetaJasperReportType;
import org.iplass.mtp.impl.web.template.report.MetaLocalizedReport;
import org.iplass.mtp.impl.web.template.report.MetaPoiReportType;
import org.iplass.mtp.impl.web.template.report.MetaReportType;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.web.template.definition.TemplateDefinition;
import org.iplass.mtp.web.template.report.definition.JasperReportType;
import org.iplass.mtp.web.template.report.definition.LocalizedReportDefinition;
import org.iplass.mtp.web.template.report.definition.PoiReportType;
import org.iplass.mtp.web.template.report.definition.ReportTemplateDefinition;
import org.iplass.mtp.web.template.report.definition.ReportType;

public class MetaReportTemplate
extends MetaTemplate {
    private static final long serialVersionUID = -8548055742699078566L;
    private String fileName;
    private byte[] binary;
    private MetaReportType reportType;
    private List<MetaLocalizedReport> localizedReportList = new ArrayList<MetaLocalizedReport>();

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public void setBinary(byte[] binary) {
        this.binary = binary;
    }

    public MetaReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(MetaReportType reportType) {
        this.reportType = reportType;
    }

    public List<MetaLocalizedReport> getLocalizedReportList() {
        return this.localizedReportList;
    }

    public void setLocalizedReportList(List<MetaLocalizedReport> localizedReportList) {
        this.localizedReportList = localizedReportList;
    }

    @Override
    public void applyConfig(TemplateDefinition definition) {
        this.fillFrom(definition);
        ReportTemplateDefinition def = (ReportTemplateDefinition)definition;
        if (def.getReportType() != null) {
            ReportType reportType = def.getReportType();
            if (reportType instanceof JasperReportType) {
                MetaJasperReportType jrt = new MetaJasperReportType();
                jrt.applyConfig(reportType);
                this.reportType = jrt;
            } else if (reportType instanceof PoiReportType) {
                MetaPoiReportType prt = new MetaPoiReportType();
                prt.applyConfig(reportType);
                this.reportType = prt;
            }
        } else {
            this.reportType = null;
        }
        this.fileName = def.getFileName();
        this.binary = def.getBinary();
        if (def.getLocalizedReportList() != null) {
            this.localizedReportList = new ArrayList<MetaLocalizedReport>();
            for (LocalizedReportDefinition ed : def.getLocalizedReportList()) {
                MetaLocalizedReport mlr = new MetaLocalizedReport();
                mlr.setLocaleName(ed.getLocaleName());
                mlr.setFileName(ed.getFileName());
                mlr.setBinary(ed.getBinary());
                if (ed.getReportType() != null) {
                    ReportType reportType = ed.getReportType();
                    if (reportType instanceof JasperReportType) {
                        MetaJasperReportType jrt = new MetaJasperReportType();
                        jrt.applyConfig(reportType);
                        mlr.setReportType(jrt);
                    } else if (reportType instanceof PoiReportType) {
                        MetaPoiReportType prt = new MetaPoiReportType();
                        prt.applyConfig(reportType);
                        mlr.setReportType(prt);
                    }
                }
                this.localizedReportList.add(mlr);
            }
        } else {
            this.localizedReportList = null;
        }
    }

    @Override
    public TemplateDefinition currentConfig() {
        ReportTemplateDefinition definition = new ReportTemplateDefinition();
        this.fillTo(definition);
        if (this.reportType != null) {
            definition.setReportType(this.reportType.currentConfig());
        }
        definition.setFileName(this.fileName);
        definition.setBinary(this.binary);
        if (this.localizedReportList != null) {
            for (MetaLocalizedReport mlr : this.localizedReportList) {
                definition.addLocalizedReport(mlr.currentConfig());
            }
        }
        return definition;
    }

    @Override
    public MetaTemplate.TemplateRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new ReportTemplateRuntime();
    }

    public class ReportTemplateRuntime
    extends MetaTemplate.TemplateRuntime {
        private static final String DOT = ".";
        private ReportingEngine reportEngine;
        private ReportingEngineService service = (ReportingEngineService)ServiceRegistry.getRegistry().getService(ReportingEngineService.class);
        private Map<String, ReportSet> reportSetMap = new HashMap<String, ReportSet>();

        public ReportTemplateRuntime() {
            if (MetaReportTemplate.this.binary == null) {
                return;
            }
            try {
                if (MetaReportTemplate.this.localizedReportList != null) {
                    for (MetaLocalizedReport mlr : MetaReportTemplate.this.localizedReportList) {
                        ReportingEngine _reportEngine = this.service.createReportingEngine(mlr.getReportType().currentConfig().getClass().getName());
                        if (_reportEngine == null) {
                            throw new TemplateRuntimeException("Report tempalte is outside of support . templateName:" + MetaReportTemplate.this.getName());
                        }
                        ReportSet reportSet = new ReportSet();
                        reportSet.reportEngine = _reportEngine;
                        ReportSet.access$402(reportSet, mlr.getBinary());
                        reportSet.reportType = mlr.getReportType();
                        reportSet.fileName = mlr.getFileName();
                        this.reportSetMap.put(mlr.getLocaleName(), reportSet);
                    }
                }
                this.reportEngine = this.service.createReportingEngine(MetaReportTemplate.this.reportType.currentConfig().getClass().getName());
                if (this.reportEngine == null) {
                    throw new TemplateRuntimeException("Report tempalte is outside of support . templateName:" + MetaReportTemplate.this.getName());
                }
            }
            catch (Exception e) {
                this.setIllegalStateException(new RuntimeException(e));
            }
        }

        @Override
        public MetaReportTemplate getMetaData() {
            return MetaReportTemplate.this;
        }

        @Override
        public void handleContent(WebRequestStack requestContext) throws IOException, ServletException {
            this.checkState();
            try {
                ReportingEngine _reportEngine = this.reportEngine;
                byte[] _binary = MetaReportTemplate.this.binary;
                MetaReportType _reportType = MetaReportTemplate.this.reportType;
                String _fileName = MetaReportTemplate.this.fileName;
                String lang = ExecuteContext.getCurrentContext().getLanguage();
                if (this.reportSetMap.get(lang) != null) {
                    _reportEngine = this.reportSetMap.get(lang).reportEngine;
                    _binary = this.reportSetMap.get(lang).binary;
                    _reportType = this.reportSetMap.get(lang).reportType;
                    _fileName = this.reportSetMap.get(lang).fileName;
                }
                try (ReportingOutputModel createOutputModel = _reportEngine.createOutputModel(_binary, _reportType.getOutputFileType(), _fileName.substring(_fileName.indexOf(DOT) + 1));){
                    _reportType.setParam(createOutputModel);
                    _reportEngine.exportReport(requestContext, createOutputModel);
                }
            }
            catch (Exception e) {
                throw new TemplateRuntimeException("The report output went wrong. templateName:" + MetaReportTemplate.this.getName(), e);
            }
            if (requestContext.getPageContext() != null) {
                throw new TemplateRuntimeException("Report tempalte can not include from jsp... templateName:" + MetaReportTemplate.this.getName());
            }
        }

        private class ReportSet {
            private ReportingEngine reportEngine;
            private byte[] binary;
            private MetaReportType reportType;
            private String fileName;

            private ReportSet() {
            }

            static /* synthetic */ byte[] access$402(ReportSet x0, byte[] x1) {
                x0.binary = x1;
                return x1;
            }
        }
    }
}

