/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import javax.servlet.http.HttpServletRequest;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.web.TenantWebInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestPath {
    private static Logger logger = LoggerFactory.getLogger(RequestPath.class);
    private static final String TENANT_NAME_HEADER = "X-Tenant-Name";
    public static final String ATTR_NAME = "mtp.requestPath";
    private WebFrontendService wfService;
    private PathType pathType;
    private TenantAuthType tenantAuthType;
    private String tenantUrl;
    private String targetPath;
    private String targetPathWithoutHeadSlash;
    private String tenantContextPath;
    private boolean isValid;
    private Boolean isDirectAccess;

    public RequestPath(String tenantUrl) {
        this.tenantUrl = tenantUrl;
    }

    public RequestPath(String targetPath, String tenantUrl, RequestPath parent) {
        this.wfService = parent.wfService;
        this.pathType = parent.pathType;
        this.tenantAuthType = parent.tenantAuthType;
        this.tenantUrl = tenantUrl;
        if (targetPath.startsWith("/")) {
            this.targetPath = targetPath;
        } else {
            this.targetPath = "/" + targetPath;
            this.targetPathWithoutHeadSlash = targetPath;
        }
    }

    public RequestPath(String targetPath, RequestPath parent) {
        this.wfService = parent.wfService;
        this.pathType = parent.pathType;
        this.tenantAuthType = parent.tenantAuthType;
        this.tenantUrl = parent.tenantUrl;
        if (targetPath.startsWith("/")) {
            this.targetPath = targetPath;
        } else {
            this.targetPath = "/" + targetPath;
            this.targetPathWithoutHeadSlash = targetPath;
        }
    }

    protected RequestPath(PathType pathType, String targetPath, TenantAuthType tenantAuthType, String tenantUrl, WebFrontendService wfService) {
        this.wfService = wfService;
        this.pathType = pathType;
        this.tenantAuthType = tenantAuthType;
        this.tenantUrl = tenantUrl;
        if (targetPath.startsWith("/")) {
            this.targetPath = targetPath;
        } else {
            this.targetPath = "/" + targetPath;
            this.targetPathWithoutHeadSlash = targetPath;
        }
    }

    public RequestPath(HttpServletRequest req, WebFrontendService wfService) {
        this.wfService = wfService;
        String pathWithoutServletContext = this.requestURIWithoutContext(req);
        if (pathWithoutServletContext.contains("..")) {
            String normReqPath = this.normalize(pathWithoutServletContext);
            if (logger.isDebugEnabled()) {
                logger.debug("request uri contains '..', so normalize uri from " + pathWithoutServletContext + " to " + normReqPath);
            }
            if (normReqPath == null) {
                pathWithoutServletContext = null;
            } else {
                pathWithoutServletContext = normReqPath;
                this.isValid = true;
            }
        } else {
            this.isValid = true;
        }
        if (this.isValid) {
            if (wfService.isExcludePath(pathWithoutServletContext)) {
                this.pathType = PathType.UNKNOWN;
            } else if (wfService.isTenantAsDomain()) {
                this.tenantUrl = req.getServerName();
                this.tenantAuthType = TenantAuthType.DOMAIN;
                this.targetPath = pathWithoutServletContext;
            } else if (wfService.getFixedTenant() != null) {
                this.tenantUrl = wfService.getFixedTenant();
                this.tenantAuthType = TenantAuthType.FIXED;
                this.targetPath = pathWithoutServletContext;
            } else {
                String headerVal = req.getHeader(TENANT_NAME_HEADER);
                if (headerVal != null) {
                    if (!headerVal.equals("/")) {
                        headerVal = "/" + headerVal;
                    }
                    this.tenantUrl = headerVal;
                    this.tenantAuthType = TenantAuthType.HEADER;
                    this.targetPath = pathWithoutServletContext;
                } else {
                    if (pathWithoutServletContext.equals("/")) {
                        this.tenantUrl = "/";
                        this.targetPath = "/";
                    } else {
                        int index = pathWithoutServletContext.indexOf(47, 1);
                        if (index < 0) {
                            this.tenantUrl = "/";
                            this.targetPath = pathWithoutServletContext;
                        } else {
                            this.tenantUrl = pathWithoutServletContext.substring(0, index);
                            this.targetPath = pathWithoutServletContext.substring(index);
                        }
                    }
                    this.tenantAuthType = TenantAuthType.PATH;
                }
                this.pathType = wfService.isThroughPath(this.targetPath) ? PathType.THROUGH : (wfService.isRestPath(this.targetPath) ? PathType.REST : PathType.ACTION);
            }
        }
    }

    public String getTargetSubPath(String prefixPath, boolean withoutHeadSlash) {
        String path = this.getTargetPath(withoutHeadSlash);
        if (path.length() > prefixPath.length() && path.startsWith(prefixPath)) {
            return path.substring(prefixPath.length());
        }
        return null;
    }

    public String getTenantContextPath(HttpServletRequest req) {
        if (this.tenantContextPath == null) {
            Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
            if (this.isDirectAccess(req)) {
                switch (this.tenantAuthType) {
                    case DOMAIN: {
                        this.tenantContextPath = req.getContextPath() + "/" + tenant.getUrl();
                        break;
                    }
                    case FIXED: {
                        this.tenantContextPath = req.getContextPath();
                        break;
                    }
                    case HEADER: {
                        if (this.wfService.isTenantAsDomain()) {
                            this.tenantContextPath = req.getContextPath() + "/" + tenant.getUrl();
                            break;
                        }
                        if ("/".equals(tenant.getUrl())) {
                            this.tenantContextPath = req.getContextPath();
                            break;
                        }
                        this.tenantContextPath = req.getContextPath() + tenant.getUrl();
                        break;
                    }
                    case PATH: {
                        if ("/".equals(tenant.getUrl())) {
                            this.tenantContextPath = req.getContextPath();
                            break;
                        }
                        this.tenantContextPath = req.getContextPath() + tenant.getUrl();
                        break;
                    }
                    default: {
                        this.tenantContextPath = req.getContextPath();
                        break;
                    }
                }
            } else {
                TenantWebInfo tweb = WebUtil.getTenantWebInfo(tenant);
                if (tweb.getUrlForRequest() != null) {
                    this.tenantContextPath = tweb.getUrlForRequest();
                    if ("/".equals(this.tenantContextPath)) {
                        this.tenantContextPath = "";
                    }
                } else {
                    switch (this.tenantAuthType) {
                        case DOMAIN: 
                        case FIXED: {
                            this.tenantContextPath = req.getContextPath();
                            break;
                        }
                        case HEADER: {
                            if (this.wfService.isTenantAsDomain()) {
                                this.tenantContextPath = req.getContextPath();
                                break;
                            }
                            if ("/".equals(tenant.getUrl())) {
                                this.tenantContextPath = req.getContextPath();
                                break;
                            }
                            this.tenantContextPath = req.getContextPath() + tenant.getUrl();
                            break;
                        }
                        case PATH: {
                            if ("/".equals(tenant.getUrl())) {
                                this.tenantContextPath = req.getContextPath();
                                break;
                            }
                            this.tenantContextPath = req.getContextPath() + tenant.getUrl();
                            break;
                        }
                        default: {
                            this.tenantContextPath = req.getContextPath();
                        }
                    }
                }
            }
        }
        return this.tenantContextPath;
    }

    public boolean isDirectAccess(HttpServletRequest req) {
        if (this.isDirectAccess == null) {
            this.isDirectAccess = this.wfService.getDirectAccessPort() != null ? Boolean.valueOf(this.wfService.getDirectAccessPort().equals(String.valueOf(req.getServerPort()))) : Boolean.FALSE;
        }
        return this.isDirectAccess;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public TenantAuthType getTenantAuthType() {
        return this.tenantAuthType;
    }

    public String getTenantUrl() {
        return this.tenantUrl;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public String getTargetPath(boolean withoutHeadSlash) {
        if (withoutHeadSlash) {
            if (this.targetPathWithoutHeadSlash == null) {
                this.targetPathWithoutHeadSlash = this.targetPath.startsWith("/") ? this.targetPath.substring(1) : this.targetPath;
            }
            return this.targetPathWithoutHeadSlash;
        }
        return this.targetPath;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private String requestURIWithoutContext(HttpServletRequest req) {
        String reqUri = req.getRequestURI();
        int contextPathLength = req.getContextPath().length();
        if (contextPathLength == 0) {
            return reqUri;
        }
        return reqUri.substring(contextPathLength);
    }

    private String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (normalized.equals("/.")) {
            return "/";
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public static enum TenantAuthType {
        DOMAIN,
        FIXED,
        HEADER,
        PATH;

    }

    public static enum PathType {
        UNKNOWN,
        REST,
        ACTION,
        THROUGH;

    }
}

