/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.contentcache;

import java.sql.Timestamp;
import java.util.List;
import java.util.function.Predicate;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.interceptor.EntityBulkUpdateInvocation;
import org.iplass.mtp.entity.interceptor.EntityCountInvocation;
import org.iplass.mtp.entity.interceptor.EntityDeleteAllInvocation;
import org.iplass.mtp.entity.interceptor.EntityDeleteInvocation;
import org.iplass.mtp.entity.interceptor.EntityInsertInvocation;
import org.iplass.mtp.entity.interceptor.EntityInterceptorAdapter;
import org.iplass.mtp.entity.interceptor.EntityLoadInvocation;
import org.iplass.mtp.entity.interceptor.EntityQueryInvocation;
import org.iplass.mtp.entity.interceptor.EntityRestoreInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateAllInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateInvocation;
import org.iplass.mtp.entity.interceptor.InvocationType;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.web.actionmapping.cache.ContentCacheContext;

public class ContentCacheInterceptor
extends EntityInterceptorAdapter {
    public String insert(EntityInsertInvocation invocation) {
        String ret = super.insert(invocation);
        ContentCacheContext.getContentCacheContext().invalidateByEntityNameAndOid(invocation.getEntityDefinition().getName(), ret);
        ContentCacheContext.getContentCacheContext().invalidateByEntityNameAndOid(invocation.getEntityDefinition().getName(), "*");
        return ret;
    }

    public void update(EntityUpdateInvocation invocation) {
        super.update(invocation);
        ContentCacheContext.getContentCacheContext().invalidateByEntityNameAndOid(invocation.getEntityDefinition().getName(), invocation.getEntity().getOid());
        ContentCacheContext.getContentCacheContext().invalidateByEntityNameAndOid(invocation.getEntityDefinition().getName(), "*");
    }

    public void delete(EntityDeleteInvocation invocation) {
        super.delete(invocation);
        ContentCacheContext.getContentCacheContext().invalidateByEntityNameAndOid(invocation.getEntityDefinition().getName(), invocation.getEntity().getOid());
        ContentCacheContext.getContentCacheContext().invalidateByEntityNameAndOid(invocation.getEntityDefinition().getName(), "*");
    }

    public int updateAll(EntityUpdateAllInvocation invocation) {
        int ret = super.updateAll(invocation);
        ContentCacheContext.getContentCacheContext().invalidateByEntityName(invocation.getUpdateCondition().getDefinitionName());
        return ret;
    }

    public void bulkUpdate(EntityBulkUpdateInvocation invocation) {
        super.bulkUpdate(invocation);
        ContentCacheContext.getContentCacheContext().invalidateByEntityName(invocation.getBulkUpdatable().getDefinitionName());
    }

    public int deleteAll(EntityDeleteAllInvocation invocation) {
        int ret = super.deleteAll(invocation);
        ContentCacheContext.getContentCacheContext().invalidateByEntityName(invocation.getDeleteCondition().getDefinitionName());
        return ret;
    }

    public Entity load(EntityLoadInvocation invocation) {
        Entity ret = super.load(invocation);
        if (invocation.getEntityDefinition().getVersionControlType() == VersionControlType.TIMEBASE) {
            Long expires = null;
            if (ret != null && ret.getEndDate() != null) {
                expires = ret.getEndDate().getTime() + 1L;
            }
            ContentCacheContext.getContentCacheContext().record(invocation.getEntityDefinition().getName(), invocation.getOid(), expires);
        } else {
            ContentCacheContext.getContentCacheContext().record(invocation.getEntityDefinition().getName(), invocation.getOid(), null);
        }
        return ret;
    }

    public void query(final EntityQueryInvocation invocation) {
        final ContentCacheContext ccc = ContentCacheContext.getContentCacheContext();
        boolean isRecordEntity = ccc.isRecordEntity(invocation.getEntityDefinition().getName());
        if (isRecordEntity) {
            final boolean isTimebase = invocation.getEntityDefinition().getVersionControlType() == VersionControlType.TIMEBASE;
            final boolean isSearchEntity = invocation.getType() == InvocationType.SEARCH_ENTITY;
            final Predicate real = invocation.getPredicate();
            final int[] indexes = new int[]{-1, -1};
            if (!isSearchEntity) {
                List vl = invocation.getQuery().getSelect().getSelectValues();
                for (int i = 0; i < vl.size(); ++i) {
                    ValueExpression v = (ValueExpression)vl.get(i);
                    if (!(v instanceof EntityField)) continue;
                    String ef = ((EntityField)v).getPropertyName();
                    if ("oid".equals(ef)) {
                        indexes[0] = i;
                        continue;
                    }
                    if (!"endDate".equals(ef)) continue;
                    indexes[1] = i;
                }
            }
            invocation.setPredicate((Predicate)new Predicate<Object>(){

                @Override
                public boolean test(Object dataModel) {
                    boolean res = real.test(dataModel);
                    if (isSearchEntity) {
                        Entity e = (Entity)dataModel;
                        if (e.getOid() != null) {
                            Long expires = null;
                            if (isTimebase && e.getEndDate() != null) {
                                expires = e.getEndDate().getTime() + 1L;
                            }
                            ccc.record(invocation.getEntityDefinition().getName(), e.getOid(), expires);
                        }
                    } else {
                        Object[] o = (Object[])dataModel;
                        String oid = null;
                        Long expires = null;
                        if (indexes[0] != -1) {
                            oid = (String)o[indexes[0]];
                        }
                        if (indexes[1] != -1 && o[indexes[1]] != null) {
                            expires = ((Timestamp)o[indexes[1]]).getTime() + 1L;
                        }
                        if (oid != null) {
                            ccc.record(invocation.getEntityDefinition().getName(), oid, expires);
                        }
                    }
                    return res;
                }
            });
        }
        super.query(invocation);
        if (isRecordEntity) {
            ccc.record(invocation.getEntityDefinition().getName(), "*", null);
        }
    }

    public int count(EntityCountInvocation invocation) {
        int ret = super.count(invocation);
        ContentCacheContext.getContentCacheContext().record(invocation.getEntityDefinition().getName(), "*", null);
        return ret;
    }

    public Entity restore(EntityRestoreInvocation invocation) {
        Entity ret = super.restore(invocation);
        ContentCacheContext.getContentCacheContext().invalidateByEntityNameAndOid(invocation.getEntityDefinition().getName(), ret.getOid());
        ContentCacheContext.getContentCacheContext().invalidateByEntityNameAndOid(invocation.getEntityDefinition().getName(), "*");
        return ret;
    }
}

