/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.token.web;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class AuthorizationRequiredException
extends WebApplicationException {
    private static final long serialVersionUID = 2602027263698869909L;
    public static final String CODE_NONE = "no_error_code_response";
    public static final String CODE_INVALID_REQUEST = "invalid_request";
    public static final String CODE_INVALID_TOKEN = "invalid_token";
    public static final String CODE_INSUFFICIENT_SCOPE = "insufficient_scope";

    public AuthorizationRequiredException(String scheme, String realm, String errorCode, String errorDescription) {
        super(errorDescription, AuthorizationRequiredException.buildResponse(scheme, realm, errorCode, errorDescription));
    }

    private static Response buildResponse(String scheme, String realm, String errorCode, String errorDescription) {
        int status;
        switch (errorCode) {
            case "invalid_request": {
                status = 400;
                break;
            }
            case "no_error_code_response": 
            case "invalid_token": {
                status = 401;
                break;
            }
            case "insufficient_scope": {
                status = 403;
                break;
            }
            default: {
                status = 500;
            }
        }
        StringBuilder resMsg = new StringBuilder();
        resMsg.append(scheme);
        resMsg.append(" ");
        if (CODE_NONE.equals(errorCode)) {
            resMsg.append("realm=\"\"");
        } else {
            boolean appended = false;
            if (realm != null) {
                resMsg.append("realm=\"").append(realm).append("\"");
                appended = true;
            }
            if (errorCode != null) {
                if (appended) {
                    resMsg.append(",");
                }
                resMsg.append("error=\"").append(errorCode).append("\"");
                appended = true;
            }
            if (errorDescription != null) {
                if (appended) {
                    resMsg.append(",");
                }
                resMsg.append("error_description=\"").append(errorDescription).append("\"");
                appended = true;
            }
        }
        if (errorDescription == null) {
            errorDescription = "";
        }
        return Response.status((int)status).header("WWW-Authenticate", (Object)resMsg.toString()).entity((Object)errorDescription).build();
    }
}

