/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.preexternal;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProviderBase;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginHandler;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginInstruction;
import org.iplass.mtp.impl.auth.authenticate.DefaultUserEntityResolver;
import org.iplass.mtp.impl.auth.authenticate.preexternal.PreExternalAccountHandle;
import org.iplass.mtp.impl.auth.authenticate.preexternal.PreExternalCredential;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.spi.Config;

public class PreExternalAuthenticationProvider
extends AuthenticationProviderBase
implements AutoLoginHandler {
    private SourceType sourceType;
    private String accountIdAttribute;
    private String uniqueKeyAttribute;
    private String[] userAttribute;
    private boolean validateOnlyLogin;
    private String logoutUrl;

    public boolean isValidateOnlyLogin() {
        return this.validateOnlyLogin;
    }

    public void setValidateOnlyLogin(boolean validateOnlyLogin) {
        this.validateOnlyLogin = validateOnlyLogin;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public String getAccountIdAttribute() {
        return this.accountIdAttribute;
    }

    public void setAccountIdAttribute(String accountIdAttribute) {
        this.accountIdAttribute = accountIdAttribute;
    }

    public String getUniqueKeyAttribute() {
        return this.uniqueKeyAttribute;
    }

    public void setUniqueKeyAttribute(String uniqueKeyAttribute) {
        this.uniqueKeyAttribute = uniqueKeyAttribute;
    }

    public String[] getUserAttribute() {
        return this.userAttribute;
    }

    public void setUserAttribute(String[] userAttribute) {
        this.userAttribute = userAttribute;
    }

    public void inited(AuthService s, Config config) {
        boolean userEntityResolverIsNull = this.getUserEntityResolver() == null;
        super.inited(s, config);
        if (userEntityResolverIsNull && this.uniqueKeyAttribute == null) {
            ((DefaultUserEntityResolver)this.getUserEntityResolver()).setUnmodifiableUniqueKeyProperty("accountId");
        }
    }

    private Object getAttribute(String attrName, HttpServletRequest req) {
        switch (this.sourceType) {
            case HEADER: {
                return req.getHeader(attrName);
            }
            case REQUEST: {
                return req.getAttribute(attrName);
            }
            case SESSION: {
                HttpSession sess = req.getSession(false);
                if (sess == null) {
                    return null;
                }
                return sess.getAttribute(attrName);
            }
        }
        return null;
    }

    public AccountHandle login(Credential credential) {
        if (!(credential instanceof PreExternalCredential)) {
            return null;
        }
        WebRequestStack reqStack = WebRequestStack.getCurrent();
        HttpServletRequest req = reqStack.getRequest();
        Object accountIdObj = this.getAttribute(this.accountIdAttribute, req);
        if (accountIdObj == null) {
            return null;
        }
        if (!accountIdObj.toString().equals(credential.getId())) {
            return null;
        }
        String uniqueKey = this.uniqueKeyAttribute != null ? this.getAttribute(this.uniqueKeyAttribute, req).toString() : credential.getId();
        HashMap<String, Object> attributes = null;
        if (this.userAttribute != null && this.userAttribute.length > 0) {
            attributes = new HashMap<String, Object>();
            for (String ua : this.userAttribute) {
                attributes.put(ua, this.getAttribute(ua, req));
            }
        }
        return new PreExternalAccountHandle(credential.getId(), uniqueKey, attributes);
    }

    public void logout(AccountHandle user) {
        WebRequestStack reqStack;
        if (user instanceof PreExternalAccountHandle && (reqStack = WebRequestStack.getCurrent()) != null && this.logoutUrl != null) {
            reqStack.getRequestContext().setAttribute("mtp.auth.loggedout", (Object)Boolean.TRUE);
            reqStack.getRequestContext().setAttribute("redirectPathAfterLogout", (Object)this.logoutUrl);
        }
    }

    public AccountManagementModule getAccountManagementModule() {
        return NO_UPDATABLE_AMM;
    }

    public Class<? extends Credential> getCredentialType() {
        return PreExternalCredential.class;
    }

    protected Class<? extends AccountHandle> getAccountHandleClassForTrust() {
        return PreExternalAccountHandle.class;
    }

    public AutoLoginHandler getAutoLoginHandler() {
        return this;
    }

    public AutoLoginInstruction handle(RequestContext req, boolean isLogined, UserContext user) {
        if (isLogined) {
            if (!this.validateOnlyLogin) {
                HttpServletRequest httpReq = (HttpServletRequest)req.getAttribute("servletRequest");
                Object accountIdObj = this.getAttribute(this.accountIdAttribute, httpReq);
                if (accountIdObj == null) {
                    return AutoLoginInstruction.LOGOUT;
                }
                if (!accountIdObj.toString().equals(user.getAccount().getCredential().getId())) {
                    return new AutoLoginInstruction((Credential)new PreExternalCredential(accountIdObj.toString()));
                }
            }
        } else {
            HttpServletRequest httpReq = (HttpServletRequest)req.getAttribute("servletRequest");
            Object accountIdObj = this.getAttribute(this.accountIdAttribute, httpReq);
            if (accountIdObj != null) {
                return new AutoLoginInstruction((Credential)new PreExternalCredential(accountIdObj.toString()));
            }
        }
        return AutoLoginInstruction.THROUGH;
    }

    public static enum SourceType {
        HEADER,
        REQUEST,
        SESSION;

    }
}

