/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.iplass.mtp.command.CommandRuntimeException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.command.definition.config.CommandConfig;
import org.iplass.mtp.command.interceptor.CommandInterceptor;
import org.iplass.mtp.impl.command.InterceptorService;
import org.iplass.mtp.impl.command.MetaCommand;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.ScriptRuntimeException;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.webapi.MetaWebApiTokenCheck;
import org.iplass.mtp.impl.webapi.WebApiGroovyTemplateBinding;
import org.iplass.mtp.impl.webapi.WebApiInvocationImpl;
import org.iplass.mtp.impl.webapi.WebApiService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.webapi.WebApiRuntimeException;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.iplass.mtp.webapi.definition.StateType;
import org.iplass.mtp.webapi.definition.WebApiDefinition;

public class MetaWebApi
extends BaseRootMetaData
implements DefinableMetaData<WebApiDefinition> {
    private static final long serialVersionUID = 2590900624234333139L;
    public static final String HEADER_ACCEPT = "Accept";
    public static final String COMMAND_INTERCEPTOR_NAME = "webApi";
    private MetaCommand command;
    private String[] results;
    private RequestType[] accepts;
    private MethodType[] methods;
    private StateType state = StateType.STATEFUL;
    private boolean supportBearerToken;
    private String restJsonParameterName = null;
    private Class<?> restJsonParameterType = Void.TYPE;
    private String restXmlParameterName = null;
    private boolean isPrivilaged = false;
    private boolean isPublicWebApi;
    private MetaWebApiTokenCheck tokenCheck;
    private boolean isCheckXRequestedWithHeader = true;
    private boolean synchronizeOnSession;
    private String responseType;
    private String accessControlAllowOrigin;
    private boolean accessControlAllowCredentials;
    private boolean needTrustedAuthenticate;

    public boolean isSupportBearerToken() {
        return this.supportBearerToken;
    }

    public void setSupportBearerToken(boolean supportBearerToken) {
        this.supportBearerToken = supportBearerToken;
    }

    public StateType getState() {
        return this.state;
    }

    public void setState(StateType state) {
        this.state = state;
    }

    public boolean isNeedTrustedAuthenticate() {
        return this.needTrustedAuthenticate;
    }

    public void setNeedTrustedAuthenticate(boolean needTrustedAuthenticate) {
        this.needTrustedAuthenticate = needTrustedAuthenticate;
    }

    public String getAccessControlAllowOrigin() {
        return this.accessControlAllowOrigin;
    }

    public void setAccessControlAllowOrigin(String accessControlAllowOrigin) {
        this.accessControlAllowOrigin = accessControlAllowOrigin;
    }

    public boolean isAccessControlAllowCredentials() {
        return this.accessControlAllowCredentials;
    }

    public void setAccessControlAllowCredentials(boolean accessControlAllowCredentials) {
        this.accessControlAllowCredentials = accessControlAllowCredentials;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public boolean isSynchronizeOnSession() {
        return this.synchronizeOnSession;
    }

    public void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public boolean isCheckXRequestedWithHeader() {
        return this.isCheckXRequestedWithHeader;
    }

    public void setCheckXRequestedWithHeader(boolean isCheckXRequestedWithHeader) {
        this.isCheckXRequestedWithHeader = isCheckXRequestedWithHeader;
    }

    public MetaWebApiTokenCheck getTokenCheck() {
        return this.tokenCheck;
    }

    public void setTokenCheck(MetaWebApiTokenCheck tokenCheck) {
        this.tokenCheck = tokenCheck;
    }

    public boolean isPrivilaged() {
        return this.isPrivilaged;
    }

    public void setPrivilaged(boolean isPrivilaged) {
        this.isPrivilaged = isPrivilaged;
    }

    public boolean isPublicWebApi() {
        return this.isPublicWebApi;
    }

    public void setPublicWebApi(boolean isPublicWebApi) {
        this.isPublicWebApi = isPublicWebApi;
    }

    public WebApiRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new WebApiRuntime();
    }

    public MetaWebApi copy() {
        return (MetaWebApi)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public MetaCommand getCommand() {
        return this.command;
    }

    public void setCommand(MetaCommand command) {
        this.command = command;
    }

    public void setResults(String[] results) {
        this.results = results;
    }

    public String[] getResults() {
        return this.results;
    }

    public RequestType[] getAccepts() {
        return this.accepts;
    }

    public void setAccepts(RequestType[] accepts) {
        this.accepts = accepts;
    }

    public MethodType[] getMethods() {
        return this.methods;
    }

    public void setMethods(MethodType[] methods) {
        this.methods = methods;
    }

    public String getRestJsonParameterName() {
        return this.restJsonParameterName;
    }

    public void setRestJsonParameterName(String restJsonParameterName) {
        this.restJsonParameterName = restJsonParameterName;
    }

    public Class<?> getRestJsonParameterType() {
        return this.restJsonParameterType;
    }

    public void setRestJsonParameterType(Class<?> restJsonParameterType) {
        this.restJsonParameterType = restJsonParameterType;
    }

    public String getRestXmlParameterName() {
        return this.restXmlParameterName;
    }

    public void setRestXmlParameterName(String restXmlParameterName) {
        this.restXmlParameterName = restXmlParameterName;
    }

    public WebApiDefinition currentConfig() {
        WebApiDefinition definition = new WebApiDefinition();
        definition.setName(this.name);
        definition.setDisplayName(this.displayName);
        definition.setDescription(this.description);
        if (this.command != null) {
            definition.setCommandConfig(this.command.currentConfig());
        }
        if (this.accepts != null) {
            definition.setAccepts(Arrays.copyOf(this.accepts, this.accepts.length));
        }
        if (this.methods != null) {
            definition.setMethods(Arrays.copyOf(this.methods, this.methods.length));
        }
        definition.setState(this.state);
        definition.setSupportBearerToken(this.supportBearerToken);
        definition.setPrivilaged(this.isPrivilaged);
        definition.setPublicWebApi(this.isPublicWebApi);
        definition.setCheckXRequestedWithHeader(this.isCheckXRequestedWithHeader);
        if (this.results != null) {
            definition.setResults(Arrays.copyOf(this.results, this.results.length));
        }
        definition.setRestJsonParameterName(this.restJsonParameterName);
        definition.setRestXmlParameterName(this.restXmlParameterName);
        if (this.restJsonParameterType != null && this.restJsonParameterType != Void.TYPE) {
            definition.setRestJsonParameterType(this.restJsonParameterType.getName());
        }
        if (this.tokenCheck != null) {
            definition.setTokenCheck(this.tokenCheck.currentConfig());
        }
        definition.setSynchronizeOnSession(this.synchronizeOnSession);
        definition.setResponseType(this.responseType);
        definition.setAccessControlAllowOrigin(this.accessControlAllowOrigin);
        definition.setAccessControlAllowCredentials(this.accessControlAllowCredentials);
        definition.setNeedTrustedAuthenticate(this.needTrustedAuthenticate);
        return definition;
    }

    public void applyConfig(WebApiDefinition definition) {
        this.name = definition.getName();
        this.displayName = definition.getDisplayName();
        this.description = definition.getDescription();
        this.results = definition.getResults() != null ? Arrays.copyOf(definition.getResults(), definition.getResults().length) : null;
        this.isPrivilaged = definition.isPrivilaged();
        this.isPublicWebApi = definition.isPublicWebApi();
        this.isCheckXRequestedWithHeader = definition.isCheckXRequestedWithHeader();
        this.accepts = definition.getAccepts() != null ? Arrays.copyOf(definition.getAccepts(), definition.getAccepts().length) : null;
        this.methods = definition.getMethods() != null ? Arrays.copyOf(definition.getMethods(), definition.getMethods().length) : null;
        this.state = definition.getState();
        this.supportBearerToken = definition.isSupportBearerToken();
        if (definition.getCommandConfig() != null) {
            this.command = MetaCommand.createInstance((CommandConfig)definition.getCommandConfig());
            this.command.applyConfig(definition.getCommandConfig());
        } else {
            this.command = null;
        }
        this.restJsonParameterName = definition.getRestJsonParameterName();
        this.restXmlParameterName = definition.getRestXmlParameterName();
        try {
            this.restJsonParameterType = definition.getRestJsonParameterType() != null ? Class.forName(definition.getRestJsonParameterType()) : null;
        }
        catch (ClassNotFoundException e) {
            throw new CommandRuntimeException(definition.getRestJsonParameterType() + " class not found.", (Throwable)e);
        }
        if (definition.getTokenCheck() != null) {
            this.tokenCheck = new MetaWebApiTokenCheck();
            this.tokenCheck.applyConfig(definition.getTokenCheck());
        } else {
            this.tokenCheck = null;
        }
        this.synchronizeOnSession = definition.isSynchronizeOnSession();
        this.responseType = definition.getResponseType();
        this.accessControlAllowOrigin = definition.getAccessControlAllowOrigin();
        this.accessControlAllowCredentials = definition.isAccessControlAllowCredentials();
        this.needTrustedAuthenticate = definition.isNeedTrustedAuthenticate();
    }

    public class WebApiRuntime
    extends BaseMetaDataRuntime {
        private MetaCommand.CommandRuntime cmd;
        private GroovyTemplate accessControlAllowOriginTemplate;
        private List<Variant> variants;
        private WebApiService service = (WebApiService)ServiceRegistry.getRegistry().getService(WebApiService.class);
        private InterceptorService is = (InterceptorService)ServiceRegistry.getRegistry().getService(InterceptorService.class);
        private MethodType specificMethod;
        private String parentName;

        public WebApiRuntime() {
            try {
                if (MetaWebApi.this.command != null) {
                    this.cmd = MetaWebApi.this.command.createRuntime();
                }
                ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                if (MetaWebApi.this.accessControlAllowOrigin != null && MetaWebApi.this.accessControlAllowOrigin.length() != 0) {
                    this.accessControlAllowOriginTemplate = GroovyTemplateCompiler.compile((String)MetaWebApi.this.accessControlAllowOrigin, (String)("AccessControlAllowOriginTemplate" + MetaWebApi.this.getName()), (GroovyScriptEngine)((GroovyScriptEngine)se));
                }
                if (MetaWebApi.this.responseType != null && MetaWebApi.this.responseType.length() != 0) {
                    String[] rtList = MetaWebApi.this.responseType.split(",");
                    MediaType[] mtList = new MediaType[rtList.length];
                    for (int i = 0; i < rtList.length; ++i) {
                        mtList[i] = MediaType.valueOf((String)rtList[i].trim());
                    }
                    this.variants = Variant.mediaTypes((MediaType[])mtList).add().build();
                } else {
                    this.variants = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE}).add().build();
                }
                for (MethodType mt : MethodType.values()) {
                    if (!MetaWebApi.this.name.endsWith(mt.toString())) continue;
                    this.specificMethod = mt;
                    this.parentName = MetaWebApi.this.name.substring(0, MetaWebApi.this.name.length() - mt.toString().length() - 1);
                    break;
                }
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        public String getPublicWebApiName() {
            if (this.specificMethod != null) {
                return this.parentName;
            }
            return MetaWebApi.this.name;
        }

        public WebApiRuntime getComprehensiveRuntime() {
            if (this.specificMethod == null) {
                return this;
            }
            return (WebApiRuntime)this.service.getRuntimeByName(this.parentName);
        }

        public List<WebApiRuntime> getIndividualRuntime() {
            ArrayList<WebApiRuntime> rl = new ArrayList<WebApiRuntime>(4);
            for (MethodType mt : MethodType.values()) {
                WebApiRuntime r = (WebApiRuntime)this.service.getRuntimeByName(this.parentName + "/" + mt.toString());
                if (r == null) continue;
                rl.add(r);
            }
            return rl;
        }

        public MethodType getSpecificMethod() {
            return this.specificMethod;
        }

        public List<Variant> getVariants() {
            return this.variants;
        }

        public String getAccessControlAllowOrigin(RequestContext req) {
            if (this.accessControlAllowOriginTemplate != null) {
                StringWriter sw = new StringWriter();
                WebApiGroovyTemplateBinding gtb = new WebApiGroovyTemplateBinding(sw, req);
                try {
                    this.accessControlAllowOriginTemplate.doTemplate((GroovyTemplateBinding)gtb);
                }
                catch (IOException e) {
                    throw new ScriptRuntimeException((Throwable)e);
                }
                String acao = sw.toString().trim();
                if (acao.length() == 0 || "null".equals(acao)) {
                    return null;
                }
                return acao;
            }
            return null;
        }

        public boolean isCorsAllowCredentials() {
            if (this.accessControlAllowOriginTemplate == null) {
                if (this.service.getCors() != null) {
                    return this.service.getCors().isAllowCredentials();
                }
                return false;
            }
            return MetaWebApi.this.accessControlAllowCredentials;
        }

        public boolean isCorsAllowOrigin(String origin, RequestContext req) {
            String acao = this.getAccessControlAllowOrigin(req);
            if (acao == null) {
                if (this.service.getCors() != null && this.service.getCors().getAllowOrigin() != null) {
                    for (String s : this.service.getCors().getAllowOrigin()) {
                        if (!this.corsAllowOrign(origin, s)) continue;
                        return true;
                    }
                }
                return false;
            }
            return this.corsAllowOrign(origin, acao);
        }

        private boolean corsAllowOrign(String origin, String accessControlAllowOrigin) {
            if (accessControlAllowOrigin != null) {
                if (accessControlAllowOrigin.indexOf(32) >= 0) {
                    String[] accessControlAllowOriginArray;
                    for (String s : accessControlAllowOriginArray = StringUtil.split((String)accessControlAllowOrigin, (char)' ')) {
                        if (!"*".equals(s) && !origin.equals(s)) continue;
                        return true;
                    }
                } else if ("*".equals(accessControlAllowOrigin) || origin.equals(accessControlAllowOrigin)) {
                    return true;
                }
            }
            return false;
        }

        public MetaWebApi getMetaData() {
            return MetaWebApi.this;
        }

        public MetaCommand.CommandRuntime getCommandRuntime() {
            return this.cmd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String executeCommand(RequestContext req, String interceptorName) {
            this.checkState();
            CommandInterceptor[] cmdInterceptors = this.is.getInterceptors(interceptorName);
            if (MetaWebApi.this.synchronizeOnSession) {
                SessionContext sessionContext = req.getSession();
                synchronized (sessionContext) {
                    return new WebApiInvocationImpl(cmdInterceptors, this, req).proceedCommand();
                }
            }
            return new WebApiInvocationImpl(cmdInterceptors, this, req).proceedCommand();
        }

        public void checkXRequestedWith(HttpServletRequest request) {
            if (MetaWebApi.this.isCheckXRequestedWithHeader) {
                for (Map.Entry<String, String> e : this.service.getXRequestedWithMap().entrySet()) {
                    String xRequestedWith = request.getHeader(e.getKey());
                    if (xRequestedWith == null || !xRequestedWith.equals(e.getValue())) continue;
                    return;
                }
                throw new WebApiRuntimeException("X-Requested-With Header( or Custom Header) is needed on WebApi:" + MetaWebApi.this.name);
            }
        }

        public void checkRequestType(RequestType requestAcceptType, HttpServletRequest request) {
            if (MetaWebApi.this.accepts != null) {
                for (RequestType a : MetaWebApi.this.accepts) {
                    if (a != requestAcceptType) continue;
                    return;
                }
            }
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }

        public void checkMethodType(MethodType requestMethodType) {
            if (MetaWebApi.this.methods == null || MetaWebApi.this.methods.length == 0) {
                return;
            }
            for (MethodType m : MetaWebApi.this.methods) {
                if (m != requestMethodType) continue;
                return;
            }
            throw new WebApplicationException(Response.Status.METHOD_NOT_ALLOWED);
        }
    }
}

