/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template.report;

import org.apache.poi.ss.usermodel.Workbook;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.definition.listeners.EventType;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.web.template.report.MetaPoiReportOutputLogic;
import org.iplass.mtp.impl.web.template.report.MetaPoiReportType;
import org.iplass.mtp.impl.web.template.report.MetaReportType;
import org.iplass.mtp.web.template.report.definition.GroovyReportOutputLogicDefinition;
import org.iplass.mtp.web.template.report.definition.ReportOutputLogicDefinition;

public class MetaGroovyPoiReportOutputLogic
extends MetaPoiReportOutputLogic {
    private static final long serialVersionUID = -5525839977593609749L;
    private String script;

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public MetaGroovyPoiReportOutputLogic copy() {
        MetaGroovyPoiReportOutputLogic copy = new MetaGroovyPoiReportOutputLogic();
        copy.script = this.script;
        return copy;
    }

    @Override
    public void applyConfig(ReportOutputLogicDefinition def) {
        GroovyReportOutputLogicDefinition d = (GroovyReportOutputLogicDefinition)def;
        this.script = d.getScript();
    }

    @Override
    public ReportOutputLogicDefinition currentConfig() {
        GroovyReportOutputLogicDefinition d = new GroovyReportOutputLogicDefinition();
        this.fillTo(d);
        d.setScript(this.script);
        return d;
    }

    @Override
    public GroovyPoiReportOutputLogicRuntime createRuntime(MetaReportType reportType) {
        return new GroovyPoiReportOutputLogicRuntime(reportType);
    }

    public class GroovyPoiReportOutputLogicRuntime
    extends MetaPoiReportOutputLogic.PoiReportOutputLogicRuntime {
        private static final String SCRIPT_PREFIX = "GroovyPoiReportOutputLogicRuntime_script";
        private Script compiledScript;
        private ScriptEngine scriptEngine;

        public GroovyPoiReportOutputLogicRuntime(MetaReportType reportType) {
            super(MetaGroovyPoiReportOutputLogic.this);
            TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
            this.scriptEngine = tc.getScriptEngine();
            if (MetaGroovyPoiReportOutputLogic.this.script != null) {
                String scriptWithImport = "import " + EventType.class.getName() + ";\n" + MetaGroovyPoiReportOutputLogic.this.script;
                String scriptName = null;
                MetaPoiReportType poiTemp = (MetaPoiReportType)reportType;
                if (poiTemp.getReportOutputLogic() != null) {
                    scriptName = "GroovyPoiReportOutputLogicRuntime_script_" + reportType.getOutputFileType() + "_" + GroovyTemplateCompiler.randomName();
                }
                this.compiledScript = this.scriptEngine.createScript(scriptWithImport, scriptName);
            }
        }

        private Object callScript(RequestContext context, Workbook book) {
            ScriptContext sc = this.scriptEngine.newScriptContext();
            sc.setAttribute("context", (Object)context);
            sc.setAttribute("book", (Object)book);
            return this.compiledScript.eval(sc);
        }

        @Override
        public void outputReport(RequestContext context, Workbook book) {
            this.callScript(context, book);
        }
    }
}

