/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.interceptors;

import java.util.List;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.interceptors.ExceptionInterceptor;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.web.interceptor.RequestInterceptor;
import org.iplass.mtp.web.interceptor.RequestInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LoggingInterceptor
implements RequestInterceptor,
ServiceInitListener<ActionMappingService> {
    private static final String MDC_ACTION = "action";
    private static Logger actionLogger = LoggerFactory.getLogger((String)"mtp.action");
    private static Logger partsLogger = LoggerFactory.getLogger((String)"mtp.action.parts");
    private boolean actionTrace = true;
    private boolean partsTrace = true;
    private String[] paramName;
    private List<String> noStackTrace;
    private List<Class<?>[]> noStackTraceClass;

    public void inited(ActionMappingService service, Config config) {
        this.noStackTraceClass = ExceptionInterceptor.toClassList(this.noStackTrace);
    }

    public void destroyed() {
    }

    public List<String> getNoStackTrace() {
        return this.noStackTrace;
    }

    public void setNoStackTrace(List<String> noStackTrace) {
        this.noStackTrace = noStackTrace;
    }

    public String[] getParamName() {
        return this.paramName;
    }

    public void setParamName(String[] paramName) {
        this.paramName = paramName;
    }

    public boolean isPartsTrace() {
        return this.partsTrace;
    }

    public void setPartsTrace(boolean partsTrace) {
        this.partsTrace = partsTrace;
    }

    @Override
    public void intercept(RequestInvocation invocation) {
        long start = -1L;
        if (this.actionTrace) {
            start = System.currentTimeMillis();
        }
        String prev = MDC.get((String)MDC_ACTION);
        MDC.put((String)MDC_ACTION, (String)invocation.getActionName());
        Throwable exp = null;
        try {
            invocation.proceedRequest();
            exp = (Throwable)invocation.getRequest().getAttribute("mtp.web.exception");
        }
        catch (RuntimeException t) {
            exp = t;
            throw t;
        }
        finally {
            if (exp != null && !(exp instanceof ApplicationException)) {
                Logger log = null;
                log = invocation.isInclude() ? partsLogger : actionLogger;
                if (this.actionTrace) {
                    if (ExceptionInterceptor.match(this.noStackTraceClass, exp)) {
                        log.error(this.getActionNameAndParam(invocation) + "," + (System.currentTimeMillis() - start) + "ms,Error," + exp.toString());
                    } else {
                        log.error(this.getActionNameAndParam(invocation) + "," + (System.currentTimeMillis() - start) + "ms,Error," + exp.toString(), exp);
                    }
                } else if (ExceptionInterceptor.match(this.noStackTraceClass, exp)) {
                    log.error(this.getActionNameAndParam(invocation) + ",Error," + exp.toString());
                } else {
                    log.error(this.getActionNameAndParam(invocation) + ",Error," + exp.toString(), exp);
                }
            } else if (this.actionTrace && !invocation.isInclude()) {
                if (exp != null) {
                    actionLogger.info(this.getActionNameAndParam(invocation) + "," + (System.currentTimeMillis() - start) + "ms,AppError," + exp.toString());
                } else {
                    actionLogger.info(this.getActionNameAndParam(invocation) + "," + (System.currentTimeMillis() - start) + "ms");
                }
            } else if (this.partsTrace && invocation.isInclude()) {
                if (exp != null) {
                    partsLogger.debug(invocation.getActionName() + "," + (System.currentTimeMillis() - start) + "ms,AppError," + exp.toString());
                } else {
                    partsLogger.debug(invocation.getActionName() + "," + (System.currentTimeMillis() - start) + "ms");
                }
            }
            if (prev == null) {
                MDC.remove((String)MDC_ACTION);
            } else {
                MDC.put((String)MDC_ACTION, (String)prev);
            }
        }
    }

    private String getActionNameAndParam(RequestInvocation invocation) {
        String actionName = WebRequestStack.getCurrent().getRequestPath().getTargetPath(true);
        if (this.paramName == null) {
            return actionName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(actionName);
        boolean isFirst = true;
        for (String p : this.paramName) {
            String val = invocation.getRequest().getParam(p);
            if (val == null) continue;
            if (isFirst) {
                sb.append("?");
                isFirst = false;
            } else {
                sb.append("&");
            }
            if (val instanceof String[]) {
                String[] valArray = (String[])val;
                for (int i = 0; i < valArray.length; ++i) {
                    if (i != 0) {
                        sb.append("&");
                    }
                    sb.append(p).append("=").append(valArray[i]);
                }
                continue;
            }
            sb.append(p).append("=").append((Object)val);
        }
        return sb.toString();
    }
}

