/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import groovy.lang.GroovyObject;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.impl.script.GroovyObjectSerializeWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSessionContext
implements SessionContext,
Serializable {
    private static final long serialVersionUID = -8791351188424167826L;
    public static final String KEY_FOR_HTTP_SERVLET_REQUEST = "org.iplass.mtp.sessionContext";
    private static Logger logger = LoggerFactory.getLogger(SimpleSessionContext.class);
    private Map<String, Object> values = new ConcurrentHashMap<String, Object>();
    private volatile transient boolean isUpdate = false;

    public Object getAttribute(String name) {
        Object val = this.values.get(name);
        if (val instanceof GroovyObjectSerializeWrapper) {
            return ((GroovyObjectSerializeWrapper)val).getObject();
        }
        return val;
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (!(value instanceof Serializable) && !(value instanceof Externalizable)) {
            logger.warn("name:" + name + ", value:" + value + " is not Serializable/Externalizable.");
        }
        if (value instanceof GroovyObject) {
            this.values.put(name, new GroovyObjectSerializeWrapper((GroovyObject)value));
        } else {
            this.values.put(name, value);
        }
        this.isUpdate = true;
    }

    public void removeAttribute(String name) {
        Object val = this.values.remove(name);
        if (val != null) {
            this.isUpdate = true;
        }
    }

    public Iterator<String> getAttributeNames() {
        return this.values.keySet().iterator();
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void resetUpdateFlag() {
        this.isUpdate = false;
    }

    public BinaryReference loadFromTemporary(long lobId) {
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        BinaryReference br = em.loadBinaryReference(lobId);
        if (br.getDefinitionName() != null) {
            return null;
        }
        return br;
    }
}

