/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckStatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(CheckStatusServlet.class);
    private String statusOk = null;
    private String statusNg = null;

    public void init() throws ServletException {
        ServletConfig config = super.getServletConfig();
        String statusOkString = config.getInitParameter("statusOk");
        this.statusOk = "OK";
        if (StringUtil.isNotBlank((String)statusOkString)) {
            this.statusOk = statusOkString;
        }
        String statusNgString = config.getInitParameter("statusNg");
        this.statusNg = "NG";
        if (StringUtil.isNotBlank((String)statusNgString)) {
            this.statusNg = statusNgString;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.exec(request, response);
    }

    private void exec(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.check(request, response);
            response.getWriter().write(this.statusOk);
        }
        catch (Throwable t) {
            response.getWriter().write(this.statusNg);
            response.sendError(500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        Connection con = null;
        try {
            RdbAdapter rdb = ((RdbAdapterService)ServiceRegistry.getRegistry().getService(RdbAdapterService.class)).getRdbAdapter();
            con = rdb.getConnection();
            try (Statement stmt = con.createStatement();){
                ResultSet rs = stmt.executeQuery(rdb.checkStatusQuery());
                rs.close();
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw t;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.exec(request, response);
    }
}

