/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.action;

import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.impl.auth.authorize.AuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.AuthorizationContextCacheLogic;
import org.iplass.mtp.impl.auth.authorize.builtin.AuthorizationContextHandler;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.action.ActionAuthContextCacheLogic;
import org.iplass.mtp.impl.auth.authorize.builtin.action.AllPermissionActionAuthContext;
import org.iplass.mtp.web.actionmapping.permission.ActionPermission;

public class ActionAuthContextHandler
extends AuthorizationContextHandler {
    private static final Class<?>[] PERM_TYPE = new Class[]{ActionPermission.class};
    private static final AllPermissionActionAuthContext DEFAULT = new AllPermissionActionAuthContext(false);

    public Class<? extends Permission>[] permissionType() {
        return PERM_TYPE;
    }

    protected String cacheNamespace() {
        return "mtp.auth.builtin.action";
    }

    protected String contextName(Permission permission) {
        return ((ActionPermission)permission).getActionName();
    }

    protected String toMetaDataPath(String contextName) {
        return "/action/" + contextName;
    }

    protected AuthorizationContextCacheLogic newAuthorizeContextCacheLogic(TenantAuthorizeContext tac) {
        return new ActionAuthContextCacheLogic(tac);
    }

    public boolean useSharedPermission(Permission permission) {
        if (((ActionPermission)permission).isExternalResource()) {
            return false;
        }
        return super.useSharedPermission(permission);
    }

    public BuiltinAuthorizationContext get(String contextName, TenantAuthorizeContext tac) {
        BuiltinAuthorizationContext actionContext;
        if (contextName.length() == 0) {
            contextName = "/";
        }
        if ((actionContext = super.get(contextName, tac)) == null) {
            String currentActionName = contextName;
            while (currentActionName.contains("/") && actionContext == null) {
                currentActionName = currentActionName.substring(0, currentActionName.lastIndexOf("/"));
                actionContext = super.get(currentActionName + "/*", tac);
            }
            if (actionContext == null) {
                actionContext = super.get("*", tac);
            }
        }
        return actionContext;
    }

    protected AuthorizationContext defaultAuthorizationContext(String contextName, TenantAuthorizeContext tac) {
        return DEFAULT;
    }
}

