/*
 * Decompiled with CFR 0.152.
 */
package org.iplantc.hibernate.util;

import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.iplantc.hibernate.util.SessionTask;
import org.iplantc.hibernate.util.SessionTaskWrapper;

public class TimedSessionTaskWrapper
extends SessionTaskWrapper {
    private static Logger LOG = Logger.getLogger(TimedSessionTaskWrapper.class);
    private String description;

    public TimedSessionTaskWrapper(SessionFactory sessionFactory, String description) {
        super(sessionFactory);
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T performTask(SessionTask<T> task) {
        long startTime = System.nanoTime();
        try {
            T t = super.performTask(task);
            return t;
        }
        finally {
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            LOG.warn((Object)(this.description + " took " + (double)duration / Math.pow(10.0, 9.0) + " seconds"));
        }
    }
}

