/*
 * Decompiled with CFR 0.152.
 */
package org.iplantc.hibernate.util;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.iplantc.hibernate.util.SessionTask;

public class SessionTaskWrapper {
    private static final Logger LOG = Logger.getLogger(SessionTaskWrapper.class);
    private SessionFactory sessionFactory;

    public SessionTaskWrapper(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public <T> T performTask(SessionTask<T> task) {
        Transaction tx = null;
        try (Session session = this.sessionFactory.openSession();){
            tx = session.beginTransaction();
            T result = task.perform((org.hibernate.Session)session);
            tx.commit();
            T t = result;
            return t;
        }
    }

    private void logNextException(HibernateException e) {
        for (Throwable currException = e; currException != null; currException = currException.getCause()) {
            if (!(currException instanceof SQLException)) continue;
            this.logNextExceptionChain((SQLException)currException);
        }
    }

    private void logNextExceptionChain(SQLException currException) {
        SQLException nextException = currException.getNextException();
        if (nextException != null) {
            LOG.error((Object)("Next Exception for " + currException), (Throwable)nextException);
            this.logNextExceptionChain(nextException);
        }
    }
}

