/*
 * Decompiled with CFR 0.152.
 */
package org.iplantc.hibernate.util;

import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibernateUtil {
    private static String LIVE_HIBERNATE_CONFIG = "hibernate.cfg.xml";
    private static SessionFactory sessionFactory = null;

    private static SessionFactory buildSessionFactory(String configFile) {
        try {
            return new Configuration().configure(configFile).buildSessionFactory();
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static void setSessionFactoryForTesting(SessionFactory newSessionFactory) {
        sessionFactory = newSessionFactory;
    }

    public static SessionFactory getSessionFactory() {
        if (sessionFactory == null) {
            sessionFactory = HibernateUtil.buildSessionFactory(LIVE_HIBERNATE_CONFIG);
        }
        return sessionFactory;
    }

    public static SessionFactory getSessionFactory(String configFile) {
        if (sessionFactory == null) {
            sessionFactory = HibernateUtil.buildSessionFactory(configFile);
        }
        return sessionFactory;
    }

    public static void shutdown() {
        HibernateUtil.getSessionFactory().close();
    }
}

