/*
 * Decompiled with CFR 0.152.
 */
package org.inurl.feign.proxy;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import org.inurl.feign.proxy.EnableFeignProxy;
import org.inurl.feign.proxy.FeignProxy;
import org.inurl.feign.proxy.FeignProxyController;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class FeignProxyRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private Environment environment;
    private EnableFeignProxy.ImplClassProvider implClassProvider;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        this.registerFeignProxyControllers(metadata, registry);
    }

    public void registerFeignProxyControllers(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(FeignProxy.class);
        scanner.addIncludeFilter((TypeFilter)annotationTypeFilter);
        Set<String> basePackages = this.getBasePackages(metadata);
        ClassPool classPool = this.getClassPool();
        EnableFeignProxy.ImplClassProvider implClassProvider = this.getImplClassProvider(metadata);
        for (String basePackage : basePackages) {
            Set candidateComponents = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition candidateComponent : candidateComponents) {
                if (!(candidateComponent instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
                AnnotationMetadata annotationMetadata = beanDefinition.getMetadata();
                Assert.isTrue((boolean)annotationMetadata.isInterface(), (String)"@FeignProxy can only be specified on an interface");
                this.registerFeignProxyController(classPool, implClassProvider, registry, beanDefinition);
            }
        }
    }

    public void registerFeignProxyController(ClassPool classPool, EnableFeignProxy.ImplClassProvider implClassProvider, BeanDefinitionRegistry registry, AnnotatedBeanDefinition beanDefinition) {
        try {
            Class<?> interfaceClass = Class.forName(beanDefinition.getBeanClassName());
            String interfaceClassName = interfaceClass.getName();
            String implClassName = implClassProvider.get(interfaceClass);
            String className = interfaceClass + "$FeignProxyController";
            CtClass implClass = classPool.get(implClassName);
            CtClass controller = classPool.makeClass(className, implClass);
            controller.addInterface(classPool.get(interfaceClassName));
            controller.addInterface(classPool.get(FeignProxyController.class.getName()));
            Class clazz = controller.toClass();
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((Class)clazz);
            AbstractBeanDefinition definition = beanDefinitionBuilder.getBeanDefinition();
            definition.setAutowireCandidate(false);
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)definition, className);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }

    private Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableFeignProxy.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : (String[])attributes.get("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : (Class[])attributes.get("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    private ClassPool getClassPool() {
        ClassPool classPool = ClassPool.getDefault();
        classPool.appendClassPath((ClassPath)new LoaderClassPath(Thread.currentThread().getContextClassLoader()));
        return classPool;
    }

    private EnableFeignProxy.ImplClassProvider getImplClassProvider(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableFeignProxy.class.getCanonicalName());
        Class implClass = (Class)attributes.get("impl");
        try {
            return (EnableFeignProxy.ImplClassProvider)implClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

