/*
 * Decompiled with CFR 0.152.
 */
package fmureader;

import com.fujitsu.vdmj.lex.ExternalFormatReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import types.Facet;
import types.Type;
import xsd2vdm.Xsd2VDM;

public class FMUReader
implements ExternalFormatReader {
    private static final String MODEL_DESCRIPTION = "modelDescription.xml";
    private static final String BUILD_DESCRIPTION = "sources/buildDescription.xml";
    private static final String TERMINALS_AND_ICONS = "icons/terminalsAndIcons.xml";
    private static final String TERMINALS_AND_ICONS_204 = "terminalsAndIcons/terminalsAndIcons.xml";

    public char[] getText(File file, Charset charset) throws IOException {
        if (file.getName().toLowerCase().endsWith(".xml")) {
            return this.processXML(file);
        }
        if (file.getName().toLowerCase().endsWith(".fmu")) {
            return this.processFMU(file);
        }
        throw new IOException("Expecting FMU or XML file");
    }

    private void validate(File filename, Reader xml) throws IOException {
        try {
            File xsd = new File(System.getProperty("fmureader.xsd", "schema/fmi3.xsd"));
            StreamSource xmlFile = new StreamSource(xml);
            xmlFile.setSystemId(filename.toURI().toASCIIString());
            StreamSource xsdFile = new StreamSource(new FileInputStream(xsd));
            xsdFile.setSystemId(xsd.toURI().toASCIIString());
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(xsdFile);
            Validator validator = schema.newValidator();
            validator.validate(xmlFile);
        }
        catch (SAXException e) {
            throw new IOException("XML validation: " + e);
        }
        catch (Exception e) {
            throw new IOException("XML validation: " + e.getMessage());
        }
    }

    private char[] processXML(File xmlFile) throws IOException {
        this.validate(xmlFile, new InputStreamReader((InputStream)new FileInputStream(xmlFile), "utf8"));
        String xmlContent = this.readFile(xmlFile);
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            PrintStream output = new PrintStream(result);
            Map<String, Type> schema = this.writeSchema(output);
            String varName = "";
            if (xmlContent.contains("<fmiModelDescription")) {
                varName = "modelDescription";
                this.missingVariable("buildDescription", output);
                this.missingVariable("terminalsAndIcons", output);
            } else if (xmlContent.contains("<fmiBuildDescription")) {
                varName = "buildDescription";
                this.missingVariable("terminalsAndIcons", output);
                this.missingVariable("modelDescription", output);
            } else if (xmlContent.contains("<fmiTerminalsAndIcons")) {
                varName = "terminalsAndIcons";
                this.missingVariable("modelDescription", output);
                this.missingVariable("buildDescription", output);
            } else {
                throw new IOException("Unknown XML content");
            }
            Xsd2VDM converter = new Xsd2VDM();
            InputSource input = new InputSource(new StringReader(xmlContent));
            input.setSystemId(new File(varName).toURI().toASCIIString());
            converter.createVDMValue(schema, output, input, xmlFile.getAbsolutePath(), varName);
            this.writeVDM(result);
            return result.toString("utf8").toCharArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private char[] processFMU(File fmuFile) throws IOException {
        String modelDescription = this.extractZipPart(fmuFile, MODEL_DESCRIPTION);
        String buildDescription = this.extractZipPart(fmuFile, BUILD_DESCRIPTION);
        String terminalsAndIcons = this.extractZipPart(fmuFile, TERMINALS_AND_ICONS, TERMINALS_AND_ICONS_204);
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            PrintStream output = new PrintStream(result);
            Map<String, Type> schema = this.writeSchema(output);
            Xsd2VDM converter = new Xsd2VDM();
            this.validate(new File(MODEL_DESCRIPTION), new StringReader(modelDescription));
            InputSource input = new InputSource(new StringReader(modelDescription));
            input.setSystemId(new File(MODEL_DESCRIPTION).toURI().toASCIIString());
            converter.createVDMValue(schema, output, input, fmuFile.getAbsolutePath(), "modelDescription");
            if (buildDescription != null) {
                this.validate(new File(BUILD_DESCRIPTION), new StringReader(buildDescription));
                input = new InputSource(new StringReader(buildDescription));
                input.setSystemId(new File(BUILD_DESCRIPTION).toURI().toASCIIString());
                converter.createVDMValue(schema, output, input, fmuFile.getAbsolutePath(), "buildDescription");
            } else {
                this.missingVariable("buildDescription", output);
            }
            if (terminalsAndIcons != null) {
                this.validate(new File(TERMINALS_AND_ICONS), new StringReader(terminalsAndIcons));
                input = new InputSource(new StringReader(terminalsAndIcons));
                input.setSystemId(new File(TERMINALS_AND_ICONS).toURI().toASCIIString());
                converter.createVDMValue(schema, output, input, fmuFile.getAbsolutePath(), "terminalsAndIcons");
            } else {
                this.missingVariable("terminalsAndIcons", output);
            }
            this.writeVDM(result);
            return result.toString("utf8").toCharArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void missingVariable(String varName, PrintStream output) {
        output.println("/**");
        output.println(" * VDM value missing");
        output.println(" */");
        output.println("values");
        output.println("    " + varName + " = nil;\n");
        output.println("\n");
    }

    private Map<String, Type> writeSchema(PrintStream output) throws Exception {
        if (Boolean.getBoolean("fmureader.noschema")) {
            output = new PrintStream(new ByteArrayOutputStream());
        }
        Xsd2VDM converter = new Xsd2VDM();
        File xsd = new File(System.getProperty("fmureader.xsd", "schema/fmi3.xsd"));
        Xsd2VDM.loadProperties((File)xsd);
        Facet.setModule((String)"");
        Map schema = converter.createVDMSchema(xsd, output, true);
        converter.xsdStandardFunctions(output);
        converter.xsdStandardDefinitions(output);
        return schema;
    }

    private String extractZipPart(File fmuFile, String ... xmlNames) throws IOException {
        StringBuilder sb = new StringBuilder();
        block0: for (String xmlName : xmlNames) {
            ZipInputStream zip = new ZipInputStream(new FileInputStream(fmuFile));
            ZipEntry ze = zip.getNextEntry();
            InputStreamReader utf = new InputStreamReader((InputStream)zip, "utf8");
            String backslashed = xmlName.replaceAll("/", "\\\\");
            while (ze != null) {
                if (ze.getName().equals(xmlName) || ze.getName().equals(backslashed)) {
                    int c = utf.read();
                    while (c > 0) {
                        sb.append((char)c);
                        c = utf.read();
                    }
                    break block0;
                }
                ze = zip.getNextEntry();
            }
            utf.close();
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private String readFile(File source) throws IOException {
        char[] data = new char[(int)source.length()];
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(source), "utf8");
        isr.read(data);
        isr.close();
        return new String(data);
    }

    private void writeVDM(ByteArrayOutputStream output) throws IOException {
        String vdmFile = System.getProperty("fmureader.vdmfile");
        if (vdmFile != null && !vdmFile.isEmpty()) {
            FileOutputStream vdm = new FileOutputStream(vdmFile);
            ((OutputStream)vdm).write(output.toByteArray());
            ((OutputStream)vdm).close();
        }
    }
}

