/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.templating.freemarker;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.infrastructurebuilder.templating.AbstractTemplatingEngine;
import org.infrastructurebuilder.util.IBUtils;

public class FreemarkerExecutionComponent
extends AbstractTemplatingEngine<Configuration> {
    static final Map<String, Object> createContext(Optional<MavenProject> project, Properties properties) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("project", project.orElse(null));
        Properties oo = project.isPresent() ? project.get().getProperties() : new Properties();
        for (Map.Entry<Object, Object> e : oo.entrySet()) {
            String propName = ((String)e.getKey()).replace('.', '_');
            String propValue = (String)e.getValue();
            context.put(propName, propValue);
        }
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String propName = (String)enumeration.nextElement();
                String propValue = properties.getProperty(propName);
                context.put(propName, propValue);
            }
        }
        return context;
    }

    public FreemarkerExecutionComponent(File src, String sourcePathRoot, boolean includeDotFiles, Optional<Log> log, Optional<Collection<String>> sourceExtensions, File sourceOutputDir, MavenProject project, boolean includeHiddenFiles, boolean caseSensitive, Optional<Path> prefixPath) {
        super(src, sourcePathRoot, includeDotFiles, log, sourceExtensions, sourceOutputDir.toPath(), project, includeHiddenFiles, caseSensitive, prefixPath);
    }

    public final Configuration createEngine(String canoPath) throws Exception {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
        FileTemplateLoader tl = new FileTemplateLoader(new File(canoPath));
        cfg.setTemplateLoader((TemplateLoader)tl);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        return cfg;
    }

    public void writeTemplate(Configuration engine, String canoTemplate, File outFile) throws Exception {
        Template template = engine.getTemplate(canoTemplate);
        Map<String, Object> _context = FreemarkerExecutionComponent.createContext(this.getProject(), this.getProperties());
        try (StringWriter out = new StringWriter();){
            template.process(_context, (Writer)out);
            outFile.getParentFile().mkdirs();
            IBUtils.writeString((Path)outFile.toPath(), (String)FreemarkerExecutionComponent.unquoteSharpsInComments((String)out.toString()));
        }
    }
}

