/*
 * Copyright © 2019 admin (admin@infrastructurebuilder.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.infrastructurebuilder.nexus.maven;

import static org.junit.jupiter.api.Assertions.assertThrows;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.infrastructurebuilder.nexus.HumanWriter;
import org.infrastructurebuilder.nexus.NexusConfigWriter;
import org.infrastructurebuilder.nexus.RepoFactory;
import org.infrastructurebuilder.nexus.RepoWriter;
import org.infrastructurebuilder.util.core.WorkingPathSupplier;
import org.joor.Reflect;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class NexusConfigWriterMojoTest {

  private static WorkingPathSupplier wps;
  private static Path                target;
  private static Path                testClasses;

  @BeforeAll
  public static void setupClass() {
    wps = new WorkingPathSupplier();
    target = wps.getRoot();
    testClasses = target.resolve("test-classes");
  }

  @AfterAll
  public static void tearDownClass() {
    wps.finalize();
  }

  Path                          path;
  Path                          baseDir;
  String                        executionIdentifier;
  boolean                       appendExecutionIdentifierToOutput;
  String                        engine;
  Map<String, String>           properties;
  Map<String, String>           propertiesAppended;
  Map<String, File>             fileToPropertiesArray;
  Map<String, File>             fileToPropertiesArrayAppended;
  List<File>                    files;
  List<File>                    filesAppendeds;
  File                          templateSources;
  File                          templateTestSources;
  File                          sourcesOutputDirectory;
  File                          testSourcesOutputDirectory;
  File                          resourcesOutputDirectory;
  File                          testResourcesOutputDirectory;
  Set<String>                   sourceExtensions;
  boolean                       includeDotFiles;
  boolean                       includeHidden;
  boolean                       includeEnvironment      = true;
  boolean                       includeSystemProperties = true;
  boolean                       dumpContext;
  MavenProject                  project;
  NexusConfigWriterPackagingMojo         sm;
  private NexusConfigWriterPackagingMojo tm;

  @BeforeEach
  public void setUp() throws Exception {
    appendExecutionIdentifierToOutput = true;
    baseDir = target.getParent();
    path = wps.get();
    project = new MavenProject();
    properties = new HashMap<>();
    propertiesAppended = new HashMap<>();
    propertiesAppended.put("X", "Y");
    fileToPropertiesArray = new HashMap<>();
    fileToPropertiesArrayAppended = new HashMap<>();
    files = new ArrayList<>();
    filesAppendeds = new ArrayList<>();
    sourceExtensions = Set.of("java", "abcs");
    final Path gensources = path.resolve("generated-sources");

    final Path sgen       = gensources.resolve("main");
    Files.createDirectories(sgen);
    sourcesOutputDirectory = sgen.toFile();
    final Path tgen = gensources.resolve("test");
    Files.createDirectories(tgen);
    testSourcesOutputDirectory = tgen.toFile();
    final Path rod = path.resolve("generated-resources");
    Files.createDirectories(rod);
    resourcesOutputDirectory = rod.toFile();
    final Path trod = path.resolve("generated-test-resources");
    Files.createDirectories(trod);
    testResourcesOutputDirectory = trod.toFile();

    // rm = (ResourcesTemplatingEngineMojo) SU(new ResourcesTemplatingEngineMojo());
    // tr = (TestResourcesTemplatingEngineMojo) SU(new
    // TestResourcesTemplatingEngineMojo());
    // sm = (NexusConfigWriterMojo) SU(new NexusConfigWriterMojo());
    // tm = (NexusConfigWriterMojo) SU(new NexusConfigWriterMojo());
  }

  @Disabled
  @Test
  public void testLocalExecute() throws MojoExecutionException, IOException, MojoFailureException {
    executionIdentifier = "test1";
    sm = (NexusConfigWriterPackagingMojo) SU(new NexusConfigWriterPackagingMojo(), executionIdentifier);
    engine = executionIdentifier;
    appendExecutionIdentifierToOutput = true;
    final Path spr = testClasses.resolve(executionIdentifier);
    Files.createDirectories(spr);
    templateSources = spr.resolve("src").resolve("main").resolve("templates").toFile();
    templateTestSources = spr.resolve("src").resolve("test").resolve("templates").toFile();

    sm.execute();
  }

  @Disabled
  @Test
  public void testLocalExecuteTest2Tests() throws MojoExecutionException, IOException, MojoFailureException {
    executionIdentifier = "test2";
    tm = (NexusConfigWriterPackagingMojo) SU(new NexusConfigWriterPackagingMojo(), executionIdentifier);
    engine = executionIdentifier;
    appendExecutionIdentifierToOutput = true;
    final Path spr = testClasses.resolve(executionIdentifier);
    Files.createDirectories(spr);
    templateSources = spr.resolve("src").resolve("test").resolve("test-templates").toFile();
    Reflect.on(tm).set("appendExecutionIdentifierToOutput", true).set("engineHint", engine)
        .set("source", templateSources).set("dumpContext", false);

    tm.execute();
  }

  @Disabled
  @Test
  public void testLocalExecuteWThrowingExecution() throws MojoExecutionException, IOException {
    executionIdentifier = "test1";
    sm = (NexusConfigWriterPackagingMojo) SU(new NexusConfigWriterPackagingMojo(), executionIdentifier);
    engine = "throw";
    appendExecutionIdentifierToOutput = true;
    final Path spr = testClasses.resolve(executionIdentifier);
    Files.createDirectories(spr);
    templateSources = spr.resolve("src").resolve("main").resolve("templates").toFile();
    templateTestSources = spr.resolve("src").resolve("test").resolve("templates").toFile();
    assertThrows(MojoExecutionException.class, () -> sm.execute());
  }

  @Disabled
  @Test
  public void testWrongEngine() throws IOException {
    executionIdentifier = "test1";
    sm = (NexusConfigWriterPackagingMojo) SU(new NexusConfigWriterPackagingMojo(), executionIdentifier);
    engine = UUID.randomUUID().toString();
    // appendExecutionIdentifierToOutput = true;
    Path spr = testClasses.resolve(executionIdentifier);
    Files.createDirectories(spr);
    templateSources = spr.resolve("src").resolve("main").resolve("templates").toFile();
    // templateTestSources =
    // spr.resolve("src").resolve("test").resolve("templates").toFile();
    // sourcePathRoot = spr.toFile();
    assertThrows(MojoExecutionException.class, () -> sm.execute());
  }

  NexusConfigWriterPackagingMojo SU(final NexusConfigWriterPackagingMojo sm, String execId) {

    Map<String, HumanWriter>   m3   = new HashMap<>();
    Map<String, RepoWriter<?>> m2   = new HashMap<>();
    Map<String, RepoFactory>   m1   = new HashMap<>();
    NexusConfigWriter          tc   = new NexusConfigWriter(m1, m2, m3);

    Logger                     l    = new ConsoleLogger(2, "TemplatingEngineMojoTest");
    final MojoExecution        mojo = new MojoExecution(new MojoDescriptor(), execId);
    sm.setComponent(tc);
    sm.setLog(new DefaultLog(l));
    sm.mojo = mojo;
    sm.setOutputDirectory(sourcesOutputDirectory);
    sm.setProject(project);

    return sm;
  }
}
