/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.nexus.maven;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.infrastructurebuilder.nexus.NexusConfigWriter;
import org.infrastructurebuilder.nexus.NexusConfigWriterConfig;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=true)
public class NexusConfigWriterMojo
extends AbstractMojo {
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    public MojoExecution mojo;
    @Parameter(required=false, defaultValue="false")
    public boolean skip;
    @Parameter(required=false, defaultValue="${project.build.directory}/generated-nexus")
    public File outputDirectory;
    @Parameter(required=true)
    public NexusConfigWriterConfig writerConfig;
    @Parameter(required=true, readonly=true, defaultValue="${project}")
    public MavenProject project;
    @Parameter(required=true)
    public String hint = "default";
    @Component
    private NexusConfigWriter component;

    public void setOutputDirectory(File out) {
        this.outputDirectory = out;
    }

    void setComp(NexusConfigWriter comp) {
        this.component = Objects.requireNonNull(comp);
    }

    public void execute() throws MojoExecutionException {
        if (!this.skip) {
            this.writerConfig.forceOutputPath(this.outputDirectory.toPath());
            this.writerConfig.forceHint(this.hint);
            try {
                this.component.execute(this.writerConfig);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to execute", (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)("Skipping templating for " + this.mojo.getExecutionId()));
        }
    }
}

