/*
 * Copyright © 2019 admin (admin@infrastructurebuilder.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.infrastructurebuilder.nexus.maven;

import java.io.File;
import java.io.IOException;
import java.util.Objects;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.infrastructurebuilder.nexus.Constants;
import org.infrastructurebuilder.nexus.NexusConfigWriter;
import org.infrastructurebuilder.nexus.NexusConfigWriterConfig;

@Mojo(name = "generate", defaultPhase = LifecyclePhase.PROCESS_RESOURCES, requiresProject = true)
public class NexusConfigWriterMojo extends AbstractMojo {

  @Parameter(defaultValue = "${mojoExecution}", readonly = true)
  public MojoExecution           mojo;

  @Parameter(required = false, defaultValue = "false")
  public boolean                 skip;

  @Parameter(required = false, defaultValue = "${project.build.directory}/generated-nexus")
  public File                    outputDirectory;

  @Parameter(required = true)
  public NexusConfigWriterConfig writerConfig;

  public void setOutputDirectory(File out) {
    this.outputDirectory = out;
  }

  @Parameter(required = true, readonly = true, defaultValue = "${project}")
  public MavenProject       project;

  @Parameter(required = true)
  public String             hint = Constants.DEFAULT;

  @Component
  private NexusConfigWriter component;

  void setComp(NexusConfigWriter comp) {
    this.component = Objects.requireNonNull(comp);
  }

  @Override
  public void execute() throws MojoExecutionException {
    if (!skip) {
      writerConfig.forceOutputPath(this.outputDirectory.toPath());
      writerConfig.forceHint(hint);
      try {
        component.execute(writerConfig);
      } catch (IOException e) {
        throw new MojoExecutionException("Failed to execute", e);
      }
    } else {
      getLog().info("Skipping templating for " + mojo.getExecutionId());
    }
  }

}
