/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.versions;

import java.util.Objects;
import java.util.Optional;
import org.infrastructurebuilder.exceptions.IBException;

public interface GAVBasic
extends Comparable<GAVBasic> {
    public static final String BASIC_PACKAGING = "jar";
    public static final String SNAPSHOT_DESIGNATOR = "-SNAPSHOT";

    default public Optional<String> asMavenDependencyGet() {
        try {
            String theVersion = this.getVersion().map(v -> v.toString()).orElseThrow(() -> new IllegalArgumentException("No version available"));
            String theClassifier = this.getClassifier().map(c -> ":" + c).orElse("");
            String theType = Optional.ofNullable(this.getExtension()).map(t -> ":" + t).orElse("".equals(theClassifier) ? "" : ":jar");
            return Optional.of(String.format("%s:%s:%s%s%s", this.getGroupId(), this.getArtifactId(), theVersion, theType, theClassifier));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    default public String getDefaultSignaturePath() {
        return String.format("%s:%s:%s%s:%s", this.getGroupId(), this.getArtifactId(), Optional.ofNullable(this.getExtension()).map(pp -> pp).orElse(BASIC_PACKAGING), this.getClassifier().map(c2 -> ":" + c2).orElse(""), this.getVersion().orElseThrow(() -> new IBException("No string version available")));
    }

    default public Optional<String> asModelId() {
        try {
            String theVersion = this.getVersion().map(v -> v.toString()).orElseThrow(() -> new IllegalArgumentException("No version available"));
            return Optional.of(String.format("%s:%s:%s", this.getGroupId(), this.getArtifactId(), theVersion));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static String asPaxUrl(GAVBasic v) {
        String cl = !v.getClassifier().isPresent() ? "" : "/" + v.getClassifier().orElse("");
        return String.format("mvn:%s/%s/%s/%s%s", v.getGroupId(), v.getArtifactId(), v.getVersion().orElse(""), v.getExtension(), cl);
    }

    default public String asPaxUrl() {
        return GAVBasic.asPaxUrl(this);
    }

    default public String asRange() {
        return "[" + this.getVersion().orElse("0.0.0,99999.99999.99999") + "]";
    }

    public String getArtifactId();

    public Optional<String> getClassifier();

    public String getExtension();

    public String getGroupId();

    public Optional<String> getVersion();

    default public Optional<String> getAPIVersion() {
        return this.getVersion().map(s -> {
            String[] splits = s.split("\\.");
            return splits[0] + "." + splits[1];
        });
    }

    default public boolean isSnapshot() {
        return this.getVersion().map(v -> v.endsWith(SNAPSHOT_DESIGNATOR)).orElse(false);
    }

    default public boolean equalsIgnoreClassifier(GAVBasic other, boolean ignoreClassifier) {
        if (!this.getExtension().equals(Objects.requireNonNull(other).getExtension())) {
            return false;
        }
        if (!this.getGroupId().equals(other.getGroupId())) {
            return false;
        }
        if (!this.getArtifactId().equals(other.getArtifactId())) {
            return false;
        }
        if (!ignoreClassifier && !Objects.equals(this.getClassifier(), other.getClassifier())) {
            return false;
        }
        return Objects.equals(this.getVersion(), other.getVersion());
    }

    @Override
    default public int compareTo(GAVBasic o) {
        if (o == null) {
            throw new NullPointerException("compareTo in DefaultGAV was passed a null");
        }
        if (this.equals(o)) {
            return 0;
        }
        int cmp = this.getGroupId().compareTo(o.getGroupId());
        if (cmp == 0 && (cmp = this.getArtifactId().compareTo(o.getArtifactId())) == 0 && (cmp = IBException.cet.returns(() -> this.compareVersion(o)).intValue()) == 0) {
            cmp = this.getExtension().compareTo(o.getExtension());
        }
        return cmp;
    }

    default public int compareVersion(GAVBasic otherVersion) {
        String v = otherVersion.getVersion().orElse(null);
        String q = this.getVersion().orElse(null);
        if (q == null && v == null) {
            return 0;
        }
        if (q == null) {
            return -1;
        }
        return q.compareTo(v);
    }
}

