/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.versions;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.infrastructurebuilder.util.versions.GAVBasic;

public class DefaultGAVBasic
implements GAVBasic {
    private String groupId;
    private String artifactId;
    private String version;
    private String extension;
    private String classifier;

    protected DefaultGAVBasic() {
    }

    public DefaultGAVBasic(String from) {
        String[] l = Arrays.copyOf(from.split(":"), 5);
        block7: for (int i = 0; i < 5; ++i) {
            switch (i) {
                case 0: {
                    this.setGroupId(l[i]);
                    continue block7;
                }
                case 1: {
                    this.setArtifactId(l[i]);
                    continue block7;
                }
                case 2: {
                    this.setVersion(l[i]);
                    continue block7;
                }
                case 3: {
                    this.setExtension(l[i]);
                    continue block7;
                }
                case 4: {
                    this.setClassifier(l[i]);
                }
            }
        }
    }

    public DefaultGAVBasic(String groupId, String artifactId, String version, String extension) {
        this(groupId, artifactId, null, version, extension);
    }

    public DefaultGAVBasic(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, "jar");
    }

    public DefaultGAVBasic(String groupId, String artifactId, String classifier, String version, String extension) {
        this.groupId = Objects.requireNonNull(groupId);
        this.artifactId = Objects.requireNonNull(artifactId);
        this.version = version;
        this.extension = extension;
        this.classifier = classifier;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public Optional<String> getClassifier() {
        return Optional.ofNullable(this.classifier);
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    protected DefaultGAVBasic setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    protected DefaultGAVBasic setArtifactId(String artifactId) {
        this.artifactId = Objects.requireNonNull(artifactId);
        return this;
    }

    protected DefaultGAVBasic setVersion(String version) {
        this.version = version;
        return this;
    }

    protected DefaultGAVBasic setExtension(String extension) {
        this.extension = Optional.ofNullable(extension).orElse("jar");
        return this;
    }

    protected DefaultGAVBasic setClassifier(String classifier) {
        this.classifier = classifier != null && "".equals(classifier.trim()) ? null : (String)Optional.ofNullable(classifier).orElse(null);
        return this;
    }
}

