/*
 * Decompiled with CFR 0.152.
 */
package com.mscharhag.et.impl;

import com.mscharhag.et.TargetExceptionResolver;
import com.mscharhag.et.TranslationException;
import com.mscharhag.et.impl.ExceptionMappings;
import com.mscharhag.et.impl.ReflectiveExceptionResolver;
import com.mscharhag.et.test.TestUtil;
import com.mscharhag.et.test.exceptions.BarRuntimeException;
import com.mscharhag.et.test.exceptions.FooRuntimeException;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionMappingsTest {
    ExceptionMappings exceptionMappings = new ExceptionMappings(null);

    @Test
    public void parentMappingsConvertExceptionToRuntimeException() {
        Exception ex = new Exception("foo");
        TestUtil.expectException(this.getTargetException(this.exceptionMappings, ex), RuntimeException.class, "foo", ex);
    }

    @Test
    public void parentMappingsDoNotConvertRuntimeException() {
        RuntimeException ex = new RuntimeException("foo");
        Assert.assertEquals((Object)ex, (Object)this.getTargetException(this.exceptionMappings, ex));
    }

    @Test
    public void itIsPossibleToOverrideDefaultMappings() {
        Exception ex = new Exception("foo");
        this.exceptionMappings.addExceptionMapping(Exception.class, (TargetExceptionResolver)new ReflectiveExceptionResolver(FooRuntimeException.class));
        TestUtil.expectException(this.getTargetException(this.exceptionMappings, ex), FooRuntimeException.class, "foo", ex);
    }

    @Test(expected=TranslationException.class)
    public void itIsNotPossibleToAddDuplicateSourceExceptionMappings() {
        this.exceptionMappings.addExceptionMapping(Exception.class, (TargetExceptionResolver)new ReflectiveExceptionResolver(FooRuntimeException.class));
        this.exceptionMappings.addExceptionMapping(Exception.class, (TargetExceptionResolver)new ReflectiveExceptionResolver(BarRuntimeException.class));
    }

    @Test(expected=TranslationException.class)
    public void itIsPossibleToGetATranslationExceptionFromNoResolver() {
        this.exceptionMappings.parentExceptionMappings = null;
        Exception ex = new Exception("foo");
        this.exceptionMappings.getExceptionResolver(Exception.class);
    }

    private RuntimeException getTargetException(ExceptionMappings mappings, Exception source) {
        TargetExceptionResolver exceptionResolver = mappings.getExceptionResolver(source.getClass());
        return exceptionResolver.getTargetException(source.getMessage(), source);
    }
}

