/*
 * Decompiled with CFR 0.152.
 */
package com.mscharhag.et;

import com.mscharhag.et.ET;
import com.mscharhag.et.ExceptionTranslator;
import com.mscharhag.et.test.TestUtil;
import com.mscharhag.oleaster.matcher.Matchers;
import java.io.IOException;
import org.junit.Test;

public class DefaultConfigurationTest {
    private ExceptionTranslator et = ET.newConfiguration().done();
    private Exception checkedException = new IOException("checked exception", null);
    private RuntimeException runtimeException = new NullPointerException("runtime exception");

    @Test
    public void translateTranslatesCheckedExceptionsToRuntimeExceptions() {
        RuntimeException result = TestUtil.catchException(() -> this.et.translate(() -> {
            throw this.checkedException;
        }));
        Matchers.expect((String)result.getMessage()).toEqual((Object)"checked exception");
        Matchers.expect((Object)result.getCause()).toEqual((Object)this.checkedException);
    }

    @Test
    public void deprecatedtranslateTranslatesCheckedExceptionsToRuntimeExceptions() {
        RuntimeException result = TestUtil.catchException(() -> this.et.withTranslation(() -> {
            throw this.checkedException;
        }));
        Matchers.expect((String)result.getMessage()).toEqual((Object)"checked exception");
        Matchers.expect((Object)result.getCause()).toEqual((Object)this.checkedException);
    }

    @Test
    public void translateDoesNothingIfNoExceptionIsThrown() {
        this.et.translate(() -> {});
    }

    @Test
    public void translateDoesNotTranslateRuntimeExceptions() {
        RuntimeException result = TestUtil.catchException(() -> this.et.translate(() -> {
            throw this.runtimeException;
        }));
        Matchers.expect((Object)result).toEqual((Object)this.runtimeException);
    }

    @Test
    public void returnsTranslatesCheckedExceptionsToRuntimeExceptions() {
        RuntimeException result = TestUtil.catchException(() -> this.et.returns(() -> {
            throw this.checkedException;
        }));
        Matchers.expect((String)result.getMessage()).toEqual((Object)"checked exception");
        Matchers.expect((Object)result.getCause()).toEqual((Object)this.checkedException);
    }

    @Test
    public void returnsReturnsTheValueIfNoExceptionIsThrown() {
        String result = (String)this.et.returns(() -> "foo");
        Matchers.expect((String)result).toEqual((Object)"foo");
    }

    @Test
    public void returnsDoesNotTranslateRuntimeExceptions() {
        RuntimeException result = TestUtil.catchException(() -> this.et.returns(() -> {
            throw this.runtimeException;
        }));
        Matchers.expect((Object)result).toEqual((Object)this.runtimeException);
    }

    @Test
    public void deprecatedreturnsDoesNotTranslateRuntimeExceptions() {
        RuntimeException result = TestUtil.catchException(() -> this.et.withReturningTranslation(() -> {
            throw this.runtimeException;
        }));
        Matchers.expect((Object)result).toEqual((Object)this.runtimeException);
    }

    @Test
    public void translateFailsIfNullIsPassed() {
        RuntimeException result = TestUtil.catchException(() -> this.et.translate(null));
        Matchers.expect(result.getClass()).toEqual(IllegalArgumentException.class);
        Matchers.expect((String)result.getMessage()).toEqual((Object)"null is not a valid argument for ET.translate()");
    }

    @Test
    public void returnsFailsIfNullIsPassed() {
        RuntimeException result = TestUtil.catchException(() -> this.et.returns(null));
        Matchers.expect(result.getClass()).toEqual(IllegalArgumentException.class);
        Matchers.expect((String)result.getMessage()).toEqual((Object)"null is not a valid argument for ET.returns()");
    }
}

