/*
 * Decompiled with CFR 0.152.
 */
package com.mscharhag.et.doc;

import com.mscharhag.et.ET;
import com.mscharhag.et.ExceptionTranslator;
import com.mscharhag.et.test.TestUtil;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class DocumentationExamplesTest {
    @Test
    public void motivation() {
        RuntimeException ex = TestUtil.catchException(() -> {
            ExceptionTranslator et = ET.newConfiguration().translate(new Class[]{SomeException.class}).to(SomeRuntimeException.class).done();
            et.withTranslation(() -> {
                throw new SomeException();
            });
        });
        Assert.assertEquals(SomeRuntimeException.class, ex.getClass());
        Assert.assertEquals(SomeException.class, ex.getCause().getClass());
    }

    @Test
    public void gettingStartedWithTranslation() {
        ExceptionTranslator et = ET.newConfiguration().translate(new Class[]{ReflectiveOperationException.class}).to(SomeRuntimeException.class).done();
        et.withTranslation(() -> {
            Method method = String.class.getMethod("toLowerCase", new Class[0]);
            String result = (String)method.invoke((Object)"FOO", new Object[0]);
        });
    }

    @Test
    public void gettingStartedWithReturningTranslation() {
        ExceptionTranslator et = ET.newConfiguration().translate(new Class[]{ReflectiveOperationException.class}).to(SomeRuntimeException.class).done();
        String result = (String)et.withReturningTranslation(() -> {
            Method method = String.class.getMethod("toLowerCase", new Class[0]);
            return (String)method.invoke((Object)"FOO", new Object[0]);
        });
        Assert.assertEquals((Object)"foo", (Object)result);
    }

    public static class SomeRuntimeException
    extends RuntimeException {
        public SomeRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    public static class SomeException
    extends Exception {
    }
}

