/*
 * Decompiled with CFR 0.152.
 */
package com.mscharhag.et;

import com.mscharhag.et.ET;
import com.mscharhag.et.ExceptionTranslator;
import com.mscharhag.et.test.TestUtil;
import com.mscharhag.et.test.exceptions.BarException;
import com.mscharhag.et.test.exceptions.BarRuntimeException;
import com.mscharhag.et.test.exceptions.FooException;
import com.mscharhag.et.test.exceptions.FooRuntimeException;
import org.junit.Test;

public class InheritedConfigurationTest {
    private ExceptionTranslator baseEt = ET.newConfiguration().translate(new Class[]{FooException.class}).to(FooRuntimeException.class).done();

    @Test
    public void baseConfigurationIsInherited() {
        ExceptionTranslator et = this.baseEt.newConfiguration().translate(new Class[]{BarException.class}).to(BarRuntimeException.class).done();
        RuntimeException result = TestUtil.translateException(et, TestUtil.FOO_EXCEPTION);
        TestUtil.expectException(result, FooRuntimeException.class, "fooException", TestUtil.FOO_EXCEPTION);
    }

    @Test
    public void baseConfigurationCanBeOverridden() {
        ExceptionTranslator et = this.baseEt.newConfiguration().translate(new Class[]{FooException.class}).to(BarRuntimeException.class).done();
        RuntimeException result = TestUtil.translateException(et, TestUtil.FOO_EXCEPTION);
        TestUtil.expectException(result, BarRuntimeException.class, "fooException", TestUtil.FOO_EXCEPTION);
    }

    @Test
    public void configurationCanBeAdded() {
        ExceptionTranslator et = this.baseEt.newConfiguration().translate(new Class[]{BarException.class}).to(BarRuntimeException.class).done();
        RuntimeException result = TestUtil.translateException(et, TestUtil.BAR_EXCEPTION);
        TestUtil.expectException(result, BarRuntimeException.class, "barException", TestUtil.BAR_EXCEPTION);
    }
}

