/*
 * Decompiled with CFR 0.152.
 */
package com.mscharhag.et;

import com.mscharhag.et.ET;
import com.mscharhag.et.ExceptionTranslator;
import com.mscharhag.et.test.TestUtil;
import com.mscharhag.oleaster.matcher.Matchers;
import java.io.IOException;
import org.junit.Test;

public class DefaultConfigurationTest {
    private ExceptionTranslator et = ET.newConfiguration().done();
    private Exception checkedException = new IOException("checked exception", null);
    private RuntimeException runtimeException = new NullPointerException("runtime exception");

    @Test
    public void withTranslationTranslatesCheckedExceptionsToRuntimeExceptions() {
        RuntimeException result = TestUtil.catchException(() -> this.et.withTranslation(() -> {
            throw this.checkedException;
        }));
        Matchers.expect((String)result.getMessage()).toEqual((Object)"checked exception");
        Matchers.expect((Object)result.getCause()).toEqual((Object)this.checkedException);
    }

    @Test
    public void withTranslationDoesNothingIfNoExceptionIsThrown() {
        this.et.withTranslation(() -> {});
    }

    @Test
    public void withTranslationDoesNotTranslateRuntimeExceptions() {
        RuntimeException result = TestUtil.catchException(() -> this.et.withTranslation(() -> {
            throw this.runtimeException;
        }));
        Matchers.expect((Object)result).toEqual((Object)this.runtimeException);
    }

    @Test
    public void withReturningTranslationTranslatesCheckedExceptionsToRuntimeExceptions() {
        RuntimeException result = TestUtil.catchException(() -> this.et.withReturningTranslation(() -> {
            throw this.checkedException;
        }));
        Matchers.expect((String)result.getMessage()).toEqual((Object)"checked exception");
        Matchers.expect((Object)result.getCause()).toEqual((Object)this.checkedException);
    }

    @Test
    public void withReturningTranslationReturnsTheValueIfNoExceptionIsThrown() {
        String result = (String)this.et.withReturningTranslation(() -> "foo");
        Matchers.expect((String)result).toEqual((Object)"foo");
    }

    @Test
    public void withReturningTranslationDoesNotTranslateRuntimeExceptions() {
        RuntimeException result = TestUtil.catchException(() -> this.et.withReturningTranslation(() -> {
            throw this.runtimeException;
        }));
        Matchers.expect((Object)result).toEqual((Object)this.runtimeException);
    }

    @Test
    public void withTranslationFailsIfNullIsPassed() {
        RuntimeException result = TestUtil.catchException(() -> this.et.withTranslation(null));
        Matchers.expect(result.getClass()).toEqual(IllegalArgumentException.class);
        Matchers.expect((String)result.getMessage()).toEqual((Object)"null is not a valid argument for ET.withTranslation()");
    }

    @Test
    public void withReturningTranslationFailsIfNullIsPassed() {
        RuntimeException result = TestUtil.catchException(() -> this.et.withReturningTranslation(null));
        Matchers.expect(result.getClass()).toEqual(IllegalArgumentException.class);
        Matchers.expect((String)result.getMessage()).toEqual((Object)"null is not a valid argument for ET.withReturningTranslation()");
    }
}

