/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.versions;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.infrastructurebuilder.exceptions.IBException;
import org.infrastructurebuilder.util.comparators.BasicTComparator;
import org.infrastructurebuilder.util.comparators.OptComparators;

public interface GAVBasic {
    public static final String DELIMITER = ":";
    public static final String SLASH = "/";
    public static final String BASIC_PACKAGING = "jar";
    public static final OptComparators.OptionalComparator<String> OPTIONAL_STRING_COMPARATOR = OptComparators.absentLastComparator(BasicTComparator.STRING_COMPARATOR);
    public static final String SNAPSHOT_DESIGNATOR = "-SNAPSHOT";
    public static final Comparator<GAVBasic> comparator = new Comparator<GAVBasic>(){

        @Override
        public int compare(GAVBasic t, GAVBasic o) {
            if (o == null) {
                throw new NullPointerException("compareTo in DefaultGAV was passed a null");
            }
            if (this.equals(o)) {
                return 0;
            }
            int cmp = t.getGroupId().compareTo(o.getGroupId());
            if (cmp == 0 && (cmp = t.getArtifactId().compareTo(o.getArtifactId())) == 0) {
                cmp = OPTIONAL_STRING_COMPARATOR.compare((String)((Object)t.getExtension()), (String)((Object)o.getExtension()));
            }
            if (cmp == 0) {
                cmp = IBException.cet.returns(() -> OPTIONAL_STRING_COMPARATOR.compare((String)((Object)t.getVersion()), (String)((Object)o.getVersion())));
            }
            return cmp;
        }
    };

    default public int compareTo(GAVBasic o) {
        return comparator.compare(this, o);
    }

    default public Optional<String> asMavenDependencyGet() {
        try {
            String theVersion = this.getVersion().map(v -> v.toString()).orElseThrow(() -> new IllegalArgumentException("No version available"));
            String theClassifier = this.getClassifier().map(c -> DELIMITER + c).orElse("");
            String theType = this.getExtension().map(t -> DELIMITER + t).orElse("".equals(theClassifier) ? "" : ":jar");
            return Optional.of(String.format("%s:%s:%s%s%s", this.getGroupId(), this.getArtifactId(), theVersion, theType, theClassifier));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    default public String getDefaultToString() {
        String[] s = new String[5];
        StringJoiner j = new StringJoiner(DELIMITER);
        s[0] = this.getGroupId();
        s[1] = this.getArtifactId();
        s[2] = this.getVersion().orElse(null);
        s[3] = this.getExtension().orElse(null);
        s[4] = this.getClassifier().orElse(null);
        for (String ss : s) {
            if (ss == null) break;
            j.add(ss);
        }
        return j.toString();
    }

    default public String getDefaultSignaturePath() {
        return String.format("%s:%s:%s%s:%s", this.getGroupId(), this.getArtifactId(), this.getExtension().orElse(BASIC_PACKAGING), this.getClassifier().map(c2 -> DELIMITER + c2).orElse(""), this.getVersion().orElseThrow(() -> new IBException("No string version available")));
    }

    default public String getDefaultURIStringPath() {
        return String.format("%s/%s/%s/%s/%s", this.getGroupId(), this.getArtifactId(), this.getVersion().orElse(""), this.getExtension().orElse(""), this.getClassifier().orElse(""));
    }

    default public Optional<String> asModelId() {
        try {
            String theVersion = this.getVersion().orElseThrow(() -> new IllegalArgumentException("No version available"));
            return Optional.of(String.format("%s:%s:%s", this.getGroupId(), this.getArtifactId(), theVersion));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static String asPaxUrl(GAVBasic v) {
        String cl = !v.getClassifier().isPresent() ? "" : SLASH + v.getClassifier().orElse("");
        return String.format("mvn:%s/%s/%s/%s%s", v.getGroupId(), v.getArtifactId(), v.getVersion().orElse(""), v.getExtension().orElse(BASIC_PACKAGING), cl);
    }

    default public String asPaxUrl() {
        return GAVBasic.asPaxUrl(this);
    }

    default public String asRange() {
        return "[" + this.getVersion().orElse("0.0.0,99999.99999.99999") + "]";
    }

    public String getArtifactId();

    public Optional<String> getClassifier();

    public Optional<String> getExtension();

    public String getGroupId();

    public Optional<String> getVersion();

    default public Optional<String> getAPIVersion() {
        return this.getVersion().map(s -> {
            String[] splits = s.split("\\.");
            return splits[0] + "." + splits[1];
        });
    }

    default public boolean isSnapshot() {
        return this.getVersion().map(v -> v.endsWith(SNAPSHOT_DESIGNATOR)).orElse(false);
    }

    default public boolean equalsIgnoreClassifier(GAVBasic other, boolean ignoreClassifier) {
        if (!this.getExtension().equals(Objects.requireNonNull(other).getExtension())) {
            return false;
        }
        if (!this.getGroupId().equals(other.getGroupId())) {
            return false;
        }
        if (!this.getArtifactId().equals(other.getArtifactId())) {
            return false;
        }
        if (!ignoreClassifier && !Objects.equals(this.getClassifier(), other.getClassifier())) {
            return false;
        }
        return Objects.equals(this.getVersion(), other.getVersion());
    }

    default public int compareVersion(GAVBasic otherVersion) {
        return OPTIONAL_STRING_COMPARATOR.compare((String)((Object)this.getVersion()), (String)((Object)otherVersion.getVersion()));
    }
}

