/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.comparators;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;

public class OptComparators<T> {
    public static final <T> OptionalComparator<T> absentFirstComparator(Comparator<T> tcmp) {
        return new AbsentFirst<T>(tcmp);
    }

    public static final <T> OptionalComparator<T> absentLastComparator(Comparator<T> tcmp) {
        return new AbsentLast<T>(tcmp);
    }

    public static final class AbsentFirst<T>
    extends AbstractOptionalComparator<T> {
        public AbsentFirst(Comparator<T> tcmp) {
            super(tcmp);
        }

        @Override
        protected int theRest(Optional<T> obj1, Optional<T> obj2) {
            if (obj1.isPresent()) {
                return -1;
            }
            if (obj2.isPresent()) {
                return 1;
            }
            return 0;
        }
    }

    public static final class AbsentLast<T>
    extends AbstractOptionalComparator<T> {
        public AbsentLast(Comparator<T> tcmp) {
            super(tcmp);
        }

        @Override
        public int theRest(Optional<T> obj1, Optional<T> obj2) {
            if (obj1.isPresent()) {
                return 1;
            }
            if (obj2.isPresent()) {
                return -1;
            }
            return 0;
        }
    }

    private static abstract class AbstractOptionalComparator<T>
    implements OptionalComparator<T> {
        private Comparator<T> tcmp;

        public AbstractOptionalComparator(Comparator<T> tcmp) {
            this.tcmp = Objects.requireNonNull(tcmp);
        }

        @Override
        public final Comparator<T> getComparator() {
            return this.tcmp;
        }

        @Override
        public final int compare(Optional<T> obj1, Optional<T> obj2) {
            if (obj1.isPresent() && obj2.isPresent()) {
                return this.getComparator().compare(obj1.get(), obj2.get());
            }
            return this.theRest(obj1, obj2);
        }

        protected abstract int theRest(Optional<T> var1, Optional<T> var2);
    }

    public static interface OptionalComparator<T>
    extends Comparator<Optional<T>> {
        public Comparator<T> getComparator();
    }
}

