/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.versions;

import org.infrastructurebuilder.util.versions.DefaultGAVBasic;
import org.infrastructurebuilder.util.versions.GAVBasic;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DefaultGAVBasicTest {
    private static final String CLASSIFIER = "classified";
    private static final String APIVERSION = "1.0";
    private static final String VERSION = "1.0.13";
    private static final String VERSION2 = "1.0.14";
    private static final String ARTIFACTID = "sample";
    private static final String GROUPID = "org.sample";
    private static final String DEPGETSTRING = "org.sample:sample:1.0.13";
    private static final String DEPGETSTRING2 = "org.sample:sample:1.0.13:jar:classified";
    private static final String SIGPATH = "org.sample:sample:jar:1.0.13";
    private static final String URIPATH = "org.sample/sample/1.0.13/jar/";
    private static final String MODELID = "org.sample:sample:1.0.13";
    private static final String VERSION2_SNAP = "1.0.14-SNAPSHOT";
    private static final String SIGPATH_SNAP = "org.sample:sample:1.0.14-SNAPSHOT";
    private GAVBasic gav;
    private GAVBasic gv2;
    private GAVBasic gv3;
    private GAVBasic gv4;
    private GAVBasic gv5;
    private GAVBasic gv6;
    private GAVBasic gv7;
    private GAVBasic gv8;
    private GAVBasic sps;

    DefaultGAVBasicTest() {
    }

    @BeforeAll
    static void setUpBeforeClass() throws Exception {
    }

    @AfterAll
    static void tearDownAfterClass() throws Exception {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.gav = new DefaultGAVBasic("org.sample:sample:1.0.13");
        this.gv2 = new DefaultGAVBasic(DEPGETSTRING2);
        this.gv3 = new DefaultGAVBasic("org.sample:sample:1.0.13:jar:classified:::");
        this.gv4 = new DefaultGAVBasic(GROUPID, ARTIFACTID, CLASSIFIER, VERSION, "jar");
        this.gv5 = new DefaultGAVBasic(GROUPID, ARTIFACTID, VERSION);
        this.gv6 = new DefaultGAVBasic(GROUPID, ARTIFACTID, CLASSIFIER, VERSION, null);
        this.gv7 = new DefaultGAVBasic(GROUPID, ARTIFACTID, null, VERSION, null);
        this.gv8 = new DefaultGAVBasic(GROUPID, ARTIFACTID, CLASSIFIER, VERSION2, "jar");
        this.sps = new DefaultGAVBasic(SIGPATH_SNAP);
    }

    @AfterEach
    void tearDown() throws Exception {
    }

    @Test
    void testDefaultToString() {
        Assert.assertEquals((Object)"org.sample:sample:1.0.13:jar", (Object)this.gav.toString());
        Assert.assertEquals((Object)DEPGETSTRING2, (Object)this.gv2.toString());
        Assert.assertEquals((Object)DEPGETSTRING2, (Object)this.gv3.toString());
        Assert.assertEquals((Object)DEPGETSTRING2, (Object)this.gv4.toString());
        Assert.assertEquals((Object)"org.sample:sample:1.0.13", (Object)this.gv5.toString());
    }

    @Test
    void testPaxURL() {
        Assert.assertEquals((Object)"mvn:org.sample/sample/1.0.13/jar", (Object)this.gav.asPaxUrl());
    }

    @Test
    void testEqualsIgnoreClassifier() {
        Assert.assertNotEquals((Object)this.gv6, (Object)this.gv7);
        Assert.assertFalse((boolean)this.gv6.equalsIgnoreClassifier(this.gv7, false));
        Assert.assertTrue((boolean)this.gv6.equalsIgnoreClassifier(this.gv7, true));
    }

    @Test
    void testCompares() {
        Assert.assertTrue((this.gv8.compareTo(this.gv4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.gv4.compareTo(this.gv8) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.gv2.compareTo(this.gv3) == 0 ? 1 : 0) != 0);
    }

    @Test
    void testAsRange() {
        Assert.assertEquals((Object)"[1.0.13]", (Object)this.gav.asRange());
    }

    @Test
    void testDefaultSigPath() {
        Assert.assertEquals((Object)SIGPATH, (Object)this.gav.getDefaultSignaturePath());
    }

    @Test
    void testDefaultURIPath() {
        Assert.assertEquals((Object)URIPATH, (Object)this.gav.getDefaultURIStringPath());
    }

    @Test
    void testGetModelId() {
        Assert.assertEquals((Object)"org.sample:sample:1.0.13", this.gav.asModelId().get());
    }

    @Test
    void testDefaultGAVBasicStringStringString() {
        Assert.assertEquals((Object)this.gav.getGroupId(), (Object)GROUPID);
        Assert.assertEquals((Object)this.gav.getArtifactId(), (Object)ARTIFACTID);
        Assert.assertEquals(this.gav.getVersion().get(), (Object)VERSION);
        Assert.assertEquals(this.gav.getAPIVersion().get(), (Object)APIVERSION);
        Assert.assertEquals((Object)this.gav, (Object)this.gav);
        Assert.assertNotEquals((Object)this.gav, (Object)APIVERSION);
        Assert.assertEquals((Object)"org.sample:sample:1.0.13:jar", this.gav.asMavenDependencyGet().get());
    }

    @Test
    void testIsSnapshot() {
        Assert.assertFalse((boolean)this.gav.isSnapshot());
        Assert.assertTrue((boolean)this.sps.isSnapshot());
    }

    @Test
    void testEquals() {
        Assert.assertEquals((Object)this.gav, (Object)this.gav);
        Assert.assertNotEquals((Object)"", (Object)this.gav);
        Assert.assertEquals((long)0L, (long)this.gav.compareTo(this.gav));
        Assert.assertThrows(NullPointerException.class, () -> this.gav.compareTo(null));
    }
}

