/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.dag.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.infrastructurebuilder.util.dag.DAG;
import org.infrastructurebuilder.util.dag.DAGVisitResult;
import org.infrastructurebuilder.util.dag.DAGVisitor;
import org.infrastructurebuilder.util.dag.DAGWalker;
import org.infrastructurebuilder.util.dag.Vertex;

public class DAGWalkerPreTraversalDepthFirstImpl<T extends Comparable<T>>
implements DAGWalker<T> {
    @Override
    public void close() throws Exception {
    }

    @Override
    public void walk(DAG<T> dag, List<DAGVisitor<T>> visitors) {
        Objects.requireNonNull(dag, "dag");
        Objects.requireNonNull(visitors, "visitors");
        Set<Vertex<T>> roots = dag.getRoots();
        Set visited = Collections.synchronizedSet(new HashSet());
        HashSet entered = new HashSet();
        roots.parallelStream().forEach(node -> this.threadedVisitation(true, visited, entered, (Vertex<T>)node, node.getChildren(), visitors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DAGVisitResult threadedVisitation(boolean isRoot, Set<Vertex<T>> visited, Set<Vertex<T>> entered, Vertex<T> node, List<Vertex<T>> children, List<DAGVisitor<T>> visitors) {
        DAGVisitResult result = DAGVisitResult.CONTINUE;
        Set<Vertex<T>> set = entered;
        synchronized (set) {
            if (entered.contains(node)) {
                return DAGVisitResult.CONTINUE;
            }
            entered.add(node);
        }
        boolean skipSiblings = false;
        boolean skipChildren = false;
        for (DAGVisitor<T> dAGVisitor : visitors) {
            result = dAGVisitor.preVisitNode(node);
            switch (result) {
                case CONTINUE: {
                    break;
                }
                case SKIP_SIBLINGS: {
                    skipSiblings = true;
                    break;
                }
                case SKIP_SUBTREE: {
                    skipChildren = true;
                    break;
                }
                case TERMINATE: {
                    return result;
                }
            }
        }
        if (!skipChildren) {
            for (DAGVisitor<T> dAGVisitor : visitors) {
                result = dAGVisitor.visitNode(node);
                visited.add(node);
                switch (result) {
                    case CONTINUE: 
                    case SKIP_SUBTREE: {
                        break;
                    }
                    case SKIP_SIBLINGS: {
                        skipChildren = true;
                        break;
                    }
                    case TERMINATE: {
                        return result;
                    }
                }
            }
            for (Vertex vertex : node.getChildren()) {
                result = this.threadedVisitation(false, visited, entered, vertex, node.getChildren(), visitors);
                if (result == DAGVisitResult.TERMINATE) {
                    return result;
                }
                if (result != DAGVisitResult.SKIP_SIBLINGS) continue;
                result = DAGVisitResult.CONTINUE;
                break;
            }
        }
        for (DAGVisitor<T> dAGVisitor : visitors) {
            result = dAGVisitor.postVisitNode(node);
            switch (result) {
                case CONTINUE: 
                case SKIP_SIBLINGS: 
                case SKIP_SUBTREE: {
                    break;
                }
                case TERMINATE: {
                    return result;
                }
            }
        }
        return skipSiblings ? DAGVisitResult.SKIP_SIBLINGS : result;
    }
}

