/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.dag.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.infrastructurebuilder.exceptions.IBException;
import org.infrastructurebuilder.util.dag.CycleDetectedException;
import org.infrastructurebuilder.util.dag.CycleDetector;
import org.infrastructurebuilder.util.dag.DAG;
import org.infrastructurebuilder.util.dag.DAGBuilder;
import org.infrastructurebuilder.util.dag.DAGVisitor;
import org.infrastructurebuilder.util.dag.DAGWalker;
import org.infrastructurebuilder.util.dag.MutableDAG;
import org.infrastructurebuilder.util.dag.MutableVertex;
import org.infrastructurebuilder.util.dag.TopologicalSorter;
import org.infrastructurebuilder.util.dag.Vertex;

public class DAGBuilderImpl<T extends Comparable<T>>
implements DAGBuilder<T> {
    private final MutableDAGImpl<T> dag;

    public DAGBuilderImpl() throws CycleDetectedException {
        this(new MutableDAGImpl());
    }

    public DAGBuilderImpl(DAG<T> inDag) throws CycleDetectedException {
        this(new MutableDAGImpl<T>(inDag));
    }

    public DAGBuilderImpl(MutableDAG<T> inDag) throws CycleDetectedException {
        this.dag = new MutableDAGImpl<T>(inDag);
    }

    @Override
    public DAGBuilder<T> addEdge(MutableVertex<T> from, MutableVertex<T> to) throws CycleDetectedException {
        this.dag.addEdge(from, to);
        return this;
    }

    @Override
    public DAGBuilder<T> addEdge(T from, T to) throws CycleDetectedException {
        this.dag.addEdge(from, to);
        return this;
    }

    @Override
    public MutableVertex<T> addVertex(T label) {
        return this.dag.addVertex(label);
    }

    @Override
    public DAG<T> build() {
        return (DAG)IBException.cet.returns(() -> new MutableDAGImpl.DAGImpl<T>(this.dag));
    }

    @Override
    public DAGBuilder<T> removeEdge(MutableVertex<T> from, MutableVertex<T> to) {
        this.dag.removeEdge(from, to);
        return this;
    }

    @Override
    public DAGBuilder<T> removeEdge(T from, T to) {
        this.dag.removeEdge(from, to);
        return this;
    }

    public static final class MutableDAGImpl<T extends Comparable<T>>
    implements Serializable,
    MutableDAG<T> {
        private static final long serialVersionUID = 7477357523381006826L;
        private final CycleDetector<T> cycleDetector = new CycleDetectorImpl();
        private final MutableTopologicalSorterImpl<T> sorter = new MutableTopologicalSorterImpl();
        private final NavigableMap<T, MutableVertexImpl<T>> vertexMap = new TreeMap<T, MutableVertexImpl<T>>();
        private final NavigableSet<MutableVertex<T>> vertexTreeSet = new TreeSet<MutableVertex<T>>();

        MutableDAGImpl() {
        }

        MutableDAGImpl(DAG<T> inDag) throws CycleDetectedException {
            for (Vertex<T> v : inDag.getVerticies()) {
                this.addVertex(v.getLabel());
                if (!v.isConnected()) continue;
                for (Comparable label : v.getChildLabels()) {
                    this.addEdge(v.getLabel(), label);
                }
            }
        }

        MutableDAGImpl(MutableDAG<T> inDag) throws CycleDetectedException {
            for (MutableVertex<T> v : inDag.getVerticies()) {
                this.addVertex(v.getLabel());
                if (!v.isConnected()) continue;
                for (Comparable label : v.getChildLabels()) {
                    this.addEdge(v.getLabel(), label);
                }
            }
        }

        @Override
        public void addEdge(MutableVertex<T> from, MutableVertex<T> to) throws CycleDetectedException {
            from.addEdgeTo(to);
            to.addEdgeFrom(from);
            List<T> cycle = this.cycleDetector.introducesCycle(to);
            if (cycle != null) {
                this.removeEdge((T)from, (T)to);
                String msg = "Edge between '" + from + "' and '" + to + "' introduces to cycle in the graph";
                throw new CycleDetectedException(msg, cycle);
            }
        }

        @Override
        public void addEdge(T from, T to) throws CycleDetectedException {
            MutableVertex<T> v1 = this.addVertex(from);
            MutableVertex<T> v2 = this.addVertex(to);
            this.addEdge((T)v1, (T)v2);
        }

        @Override
        public MutableVertex<T> addVertex(T label) {
            MutableVertexImpl<T> retValue = null;
            if (this.vertexMap.containsKey(label)) {
                retValue = (MutableVertexImpl<T>)this.vertexMap.get(label);
            } else {
                retValue = new MutableVertexImpl<T>(label, this.sorter);
                this.vertexMap.put(label, retValue);
                this.vertexTreeSet.add(retValue);
            }
            return retValue;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MutableDAG other = (MutableDAG)obj;
            List<T> l1 = this.sorter.sort(this);
            List<T> r1 = this.sorter.sort(other);
            if (l1.size() != r1.size()) {
                return false;
            }
            Iterator<T> li = l1.iterator();
            Iterator<T> ri = r1.iterator();
            while (li.hasNext()) {
                if (((Comparable)li.next()).compareTo((Comparable)ri.next()) == 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<T> getChildLabels(T label) {
            return this.getVertex(label).getChildLabels();
        }

        @Override
        public Set<T> getLabels() {
            return this.vertexMap.keySet();
        }

        @Override
        public List<T> getParentLabels(T label) {
            return this.getVertex(label).getParentLabels();
        }

        @Override
        public List<T> getSuccessorLabels(T label) {
            List<T> retValue;
            MutableVertex<T> vertex = this.getVertex(label);
            if (vertex.isLeaf()) {
                retValue = new ArrayList<T>(1);
                retValue.add(label);
            } else {
                retValue = new MutableTopologicalSorterImpl<T>().sort(vertex);
            }
            return retValue;
        }

        @Override
        public MutableVertex<T> getVertex(T label) {
            MutableVertex retValue = (MutableVertex)this.vertexMap.get(label);
            return retValue;
        }

        @Override
        public Set<MutableVertex<T>> getVerticies() {
            return this.vertexTreeSet;
        }

        @Override
        public boolean hasEdge(T label1, T label2) {
            MutableVertex<T> v1 = this.getVertex(label1);
            if (v1 != null) {
                MutableVertex<T> v2 = this.getVertex(label2);
                boolean retValue = v1.getChildren().contains(v2);
                return retValue;
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.vertexTreeSet.hashCode();
            result = 31 * result + this.vertexMap.hashCode();
            return result;
        }

        @Override
        public boolean isConnected(T label) {
            return this.getVertex(label).isConnected();
        }

        @Override
        public void removeEdge(MutableVertex<T> from, MutableVertex<T> to) {
            from.removeEdgeTo(to);
            to.removeEdgeFrom(from);
        }

        @Override
        public void removeEdge(T from, T to) {
            MutableVertex<T> v1 = this.addVertex(from);
            MutableVertex<T> v2 = this.addVertex(to);
            this.removeEdge((T)v1, (T)v2);
        }

        static class MutableTopologicalSorterImpl<T extends Comparable<T>> {
            private final Integer NOT_VISTITED = 0;
            private final Integer VISITED = 2;
            private final Integer VISITING = 1;

            MutableTopologicalSorterImpl() {
            }

            public List<T> sort(MutableDAG<T> graph) {
                return this.dfs(graph);
            }

            public List<T> sort(MutableVertex<T> MutableVertex2) {
                LinkedList retValue = new LinkedList();
                this.dfsVisit(MutableVertex2, new HashMap<MutableVertex<T>, Integer>(), retValue);
                return retValue;
            }

            private List<T> dfs(MutableDAG<T> graph) {
                LinkedList retValue = new LinkedList();
                HashMap<MutableVertex<T>, Integer> MutableVertexStateMap = new HashMap<MutableVertex<T>, Integer>();
                for (MutableVertex<T> MutableVertex2 : graph.getVerticies()) {
                    if (!this.isNotVisited(MutableVertex2, MutableVertexStateMap)) continue;
                    this.dfsVisit(MutableVertex2, MutableVertexStateMap, retValue);
                }
                return retValue;
            }

            private void dfsVisit(MutableVertex<T> MutableVertex2, Map<MutableVertex<T>, Integer> MutableVertexStateMap, List<T> list) {
                MutableVertexStateMap.put(MutableVertex2, this.VISITING);
                for (MutableVertex<T> v : MutableVertex2.getChildren()) {
                    if (!this.isNotVisited(v, MutableVertexStateMap)) continue;
                    this.dfsVisit(v, MutableVertexStateMap, list);
                }
                MutableVertexStateMap.put(MutableVertex2, this.VISITED);
                list.add(MutableVertex2.getLabel());
            }

            private boolean isNotVisited(MutableVertex<T> MutableVertex2, Map<MutableVertex<T>, Integer> MutableVertexStateMap) {
                Integer state = MutableVertexStateMap.get(MutableVertex2);
                return state == null || this.NOT_VISTITED.equals(state);
            }
        }

        static class MutableVertexImpl<T extends Comparable<T>>
        implements Serializable,
        MutableVertex<T> {
            private static final long serialVersionUID = -5583117388101863872L;
            private final T label;
            private final MutableTopologicalSorterImpl<T> sorter;
            final List<MutableVertex<T>> children = new ArrayList<MutableVertex<T>>();
            final List<MutableVertex<T>> parents = new ArrayList<MutableVertex<T>>();

            MutableVertexImpl(T label, MutableTopologicalSorterImpl<T> sorter) {
                this.label = (Comparable)Objects.requireNonNull(label);
                this.sorter = Objects.requireNonNull(sorter);
            }

            @Override
            public void addEdgeFrom(MutableVertex<T> vertex) {
                this.parents.add(vertex);
            }

            @Override
            public void addEdgeTo(MutableVertex<T> vertex) {
                this.children.add(vertex);
            }

            @Override
            public int compareTo(MutableVertex<T> o) {
                int retval = this.getLabel().compareTo(o.getLabel());
                return retval;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof MutableVertex)) {
                    return false;
                }
                MutableVertex other = (MutableVertex)obj;
                if (!this.label.equals(other.getLabel())) {
                    return false;
                }
                List<T> l1 = this.sorter.sort(this);
                List<T> r1 = this.sorter.sort(other);
                if (!Arrays.deepEquals(l1.toArray(), r1.toArray())) {
                    return false;
                }
                return this.parents.equals(other.getParents());
            }

            @Override
            public List<T> getChildLabels() {
                ArrayList<T> retValue = new ArrayList<T>(this.children.size());
                for (MutableVertex<T> vertex : this.children) {
                    retValue.add(vertex.getLabel());
                }
                return retValue;
            }

            @Override
            public List<MutableVertex<T>> getChildren() {
                return this.children;
            }

            @Override
            public T getLabel() {
                return this.label;
            }

            @Override
            public List<T> getParentLabels() {
                ArrayList<T> retValue = new ArrayList<T>(this.parents.size());
                for (MutableVertex<T> vertex : this.parents) {
                    retValue.add(vertex.getLabel());
                }
                return retValue;
            }

            @Override
            public List<MutableVertex<T>> getParents() {
                return this.parents;
            }

            @Override
            public boolean isConnected() {
                return this.parents.size() > 0 || this.children.size() > 0;
            }

            @Override
            public boolean isLeaf() {
                return this.children.size() == 0;
            }

            @Override
            public boolean isRoot() {
                return this.parents.size() == 0;
            }

            @Override
            public void removeEdgeFrom(MutableVertex<T> vertex) {
                this.parents.remove(vertex);
            }

            @Override
            public void removeEdgeTo(MutableVertex<T> vertex) {
                this.children.remove(vertex);
            }

            public String toString() {
                return "Vertex{label='" + this.label + "'}";
            }
        }

        public static final class DAGImpl<T extends Comparable<T>>
        implements Serializable,
        DAG<T> {
            private static final long serialVersionUID = 8128453028940561054L;
            private final TopologicalSorter<T> sorter = new DepthFirstTopologicalSorterImpl();
            private final NavigableMap<T, VertexImpl<T>> vertexMap = new TreeMap<T, VertexImpl<T>>();
            private final NavigableSet<Vertex<T>> vertexTreeSet = new TreeSet<Vertex<T>>();

            public DAGImpl(MutableDAG<T> inDag) throws CycleDetectedException {
                for (MutableVertex<T> v : inDag.getVerticies()) {
                    this.addVertex(v.getLabel());
                    if (!v.isConnected()) continue;
                    for (Comparable label : v.getChildLabels()) {
                        this.addEdge(v.getLabel(), label);
                    }
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                DAG other = (DAG)obj;
                HashSet others = new HashSet();
                others.addAll(other.getVerticies());
                for (Vertex<T> vertex : this.getVerticies()) {
                    List otherChildren;
                    List otherParents;
                    T label = vertex.getLabel();
                    Vertex<T> otherV = other.getVertex(label);
                    if (otherV == null) {
                        return false;
                    }
                    List thisParents = vertex.getParentLabels().stream().distinct().sorted().collect(Collectors.toList());
                    if (!thisParents.equals(otherParents = otherV.getParentLabels().stream().distinct().sorted().collect(Collectors.toList()))) {
                        return false;
                    }
                    List thisChildren = vertex.getChildLabels().stream().distinct().sorted().collect(Collectors.toList());
                    if (!thisChildren.equals(otherChildren = otherV.getChildLabels().stream().distinct().sorted().collect(Collectors.toList()))) {
                        return false;
                    }
                    others.remove(otherV);
                }
                return others.size() == 0;
            }

            @Override
            public List<T> getChildLabels(T label) {
                return this.getVertex(label).getChildLabels();
            }

            @Override
            public Set<T> getLabels() {
                return this.vertexMap.keySet();
            }

            @Override
            public List<T> getParentLabels(T label) {
                return this.getVertex(label).getParentLabels();
            }

            @Override
            public Set<Vertex<T>> getRoots() {
                return this.vertexTreeSet.stream().filter(v -> v.getParentLabels().size() == 0).collect(Collectors.toSet());
            }

            @Override
            public List<T> getSuccessorLabels(T label) {
                List<T> retValue;
                Vertex<T> vertex = this.getVertex(label);
                if (vertex.isLeaf()) {
                    retValue = new ArrayList<T>(1);
                    retValue.add(label);
                } else {
                    retValue = new DepthFirstTopologicalSorterImpl<T>().sort(vertex);
                }
                return retValue;
            }

            @Override
            public Vertex<T> getVertex(T label) {
                Vertex retValue = (Vertex)this.vertexMap.get(label);
                return retValue;
            }

            @Override
            public Set<Vertex<T>> getVerticies() {
                return this.vertexTreeSet;
            }

            @Override
            public boolean hasEdge(T label1, T label2) {
                Vertex<T> v1 = this.getVertex(label1);
                if (v1 != null) {
                    Vertex<T> v2 = this.getVertex(label2);
                    boolean retValue = v1.getChildren().contains(v2);
                    return retValue;
                }
                return false;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.vertexTreeSet.hashCode();
                result = 31 * result + this.vertexMap.hashCode();
                return result;
            }

            @Override
            public boolean isConnected(T label) {
                return this.getVertex(label).isConnected();
            }

            @Override
            public void walk(DAGWalker<T> walker, List<DAGVisitor<T>> visitors) {
                Objects.requireNonNull(walker, "DAGWalker").walk(this, Objects.requireNonNull(visitors, "DAGWalk Visitors"));
            }

            private void addEdge(T from, T to) throws CycleDetectedException {
                VertexImpl<T> v1 = this.addVertex(from);
                VertexImpl<T> v2 = this.addVertex(to);
                this.addEdge(v1, v2);
            }

            private void addEdge(VertexImpl<T> from, VertexImpl<T> to) {
                from.addEdgeTo(to);
                to.addEdgeFrom(from);
            }

            private VertexImpl<T> addVertex(T label) {
                VertexImpl retValue = null;
                if (this.vertexMap.containsKey(label)) {
                    retValue = (VertexImpl)this.vertexMap.get(label);
                } else {
                    retValue = new VertexImpl(this, this, label);
                    this.vertexMap.put(label, retValue);
                    this.vertexTreeSet.add(retValue);
                }
                return retValue;
            }

            public static final class DepthFirstTopologicalSorterImpl<T extends Comparable<T>>
            implements TopologicalSorter<T> {
                private final Integer NOT_VISTITED = 0;
                private final Integer VISITED = 2;
                private final Integer VISITING = 1;

                @Override
                public List<T> sort(DAG<T> graph) {
                    return this.dfs(graph);
                }

                @Override
                public List<T> sort(Vertex<T> Vertex2) {
                    LinkedList retValue = new LinkedList();
                    this.dfsVisit(Vertex2, new HashMap<Vertex<T>, Integer>(), retValue);
                    return retValue;
                }

                private List<T> dfs(DAG<T> graph) {
                    LinkedList retValue = new LinkedList();
                    HashMap<Vertex<T>, Integer> VertexStateMap = new HashMap<Vertex<T>, Integer>();
                    for (Vertex<T> Vertex2 : graph.getVerticies()) {
                        if (!this.isNotVisited(Vertex2, VertexStateMap)) continue;
                        this.dfsVisit(Vertex2, VertexStateMap, retValue);
                    }
                    return retValue;
                }

                private void dfsVisit(Vertex<T> Vertex2, Map<Vertex<T>, Integer> VertexStateMap, List<T> list) {
                    VertexStateMap.put(Vertex2, this.VISITING);
                    for (Vertex<T> v : Vertex2.getChildren()) {
                        if (!this.isNotVisited(v, VertexStateMap)) continue;
                        this.dfsVisit(v, VertexStateMap, list);
                    }
                    VertexStateMap.put(Vertex2, this.VISITED);
                    list.add(Vertex2.getLabel());
                }

                private boolean isNotVisited(Vertex<T> Vertex2, Map<Vertex<T>, Integer> VertexStateMap) {
                    Integer state = VertexStateMap.get(Vertex2);
                    return state == null || this.NOT_VISTITED.equals(state);
                }
            }

            private static class VertexImpl<T extends Comparable<T>>
            implements Serializable,
            Vertex<T> {
                private static final long serialVersionUID = -7908862588481132800L;
                private final DAGImpl<T> dag;
                private final String id = UUID.randomUUID().toString();
                private final T label;
                final List<Vertex<T>> children = new ArrayList<Vertex<T>>();
                final List<Vertex<T>> parents = new ArrayList<Vertex<T>>();
                final /* synthetic */ DAGImpl this$0;

                public VertexImpl(DAGImpl<T> dagImpl, T label) {
                    this.this$0 = var1_1;
                    this.dag = dagImpl;
                    this.label = (Comparable)Objects.requireNonNull(label);
                }

                public void addEdgeTo(Vertex<T> to) {
                    this.children.add(to);
                }

                @Override
                public int compareTo(Vertex<T> o) {
                    int retval = this.getLabel().compareTo(o.getLabel());
                    return retval;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (!(obj instanceof Vertex)) {
                        return false;
                    }
                    Vertex other = (Vertex)obj;
                    if (!this.label.equals(other.getLabel())) {
                        return false;
                    }
                    List l1 = this.dag.sorter.sort(this);
                    List r1 = this.dag.sorter.sort(other);
                    if (!Arrays.deepEquals(l1.toArray(), r1.toArray())) {
                        return false;
                    }
                    return this.parents.equals(other.getParents());
                }

                @Override
                public List<T> getChildLabels() {
                    ArrayList<T> retValue = new ArrayList<T>(this.children.size());
                    for (Vertex<T> vertex : this.children) {
                        retValue.add(vertex.getLabel());
                    }
                    return retValue;
                }

                @Override
                public List<Vertex<T>> getChildren() {
                    return this.children;
                }

                @Override
                public String getId() {
                    return this.id;
                }

                @Override
                public T getLabel() {
                    return this.label;
                }

                @Override
                public List<T> getParentLabels() {
                    ArrayList<T> retValue = new ArrayList<T>(this.parents.size());
                    for (Vertex<T> vertex : this.parents) {
                        retValue.add(vertex.getLabel());
                    }
                    return retValue;
                }

                @Override
                public List<Vertex<T>> getParents() {
                    return this.parents;
                }

                @Override
                public boolean isConnected() {
                    return this.parents.size() > 0 || this.children.size() > 0;
                }

                @Override
                public boolean isLeaf() {
                    return this.children.size() == 0;
                }

                @Override
                public boolean isRoot() {
                    return this.parents.size() == 0;
                }

                public String toString() {
                    return "Vertex{label='" + this.label + "'}";
                }

                private void addEdgeFrom(Vertex<T> from) {
                    this.parents.add(from);
                }
            }
        }
    }

    static class CycleDetectorImpl<T extends Comparable<T>>
    implements CycleDetector<T> {
        private final Integer NOT_VISTITED = 0;
        private final Integer VISITED = 2;
        private final Integer VISITING = 1;

        CycleDetectorImpl() {
        }

        @Override
        public List<T> introducesCycle(MutableVertex<T> vertex) {
            HashMap<MutableVertex<T>, Integer> vertexStateMap = new HashMap<MutableVertex<T>, Integer>();
            return this.introducesCycle(vertex, vertexStateMap);
        }

        @Override
        public List<T> introducesCycle(MutableVertex<T> vertex, Map<MutableVertex<T>, Integer> vertexStateMap) {
            LinkedList cycleStack = new LinkedList();
            boolean hasCycle = this.dfsVisit(vertex, cycleStack, vertexStateMap);
            if (hasCycle) {
                Comparable label = (Comparable)cycleStack.getFirst();
                int pos = cycleStack.lastIndexOf(label);
                List cycle = cycleStack.subList(0, pos + 1);
                Collections.reverse(cycle);
                return cycle;
            }
            return null;
        }

        private boolean dfsVisit(MutableVertex<T> vertex, LinkedList<T> cycle, Map<MutableVertex<T>, Integer> vertexStateMap) {
            cycle.addFirst(vertex.getLabel());
            vertexStateMap.put(vertex, this.VISITING);
            for (MutableVertex<T> v : vertex.getChildren()) {
                if (this.isNotVisited(v, vertexStateMap)) {
                    boolean hasCycle = this.dfsVisit(v, cycle, vertexStateMap);
                    if (!hasCycle) continue;
                    return true;
                }
                if (!this.isVisiting(v, vertexStateMap)) continue;
                cycle.addFirst(v.getLabel());
                return true;
            }
            vertexStateMap.put(vertex, this.VISITED);
            cycle.removeFirst();
            return false;
        }

        private boolean isNotVisited(MutableVertex<T> vertex, Map<MutableVertex<T>, Integer> vertexStateMap) {
            Integer state = vertexStateMap.get(vertex);
            return state == null || this.NOT_VISTITED.equals(state);
        }

        private boolean isVisiting(MutableVertex<T> vertex, Map<MutableVertex<T>, Integer> vertexStateMap) {
            Integer state = vertexStateMap.get(vertex);
            return this.VISITING.equals(state);
        }
    }
}

