/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.dag.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.infrastructurebuilder.util.dag.CycleDetectedException;
import org.infrastructurebuilder.util.dag.MutableVertex;
import org.infrastructurebuilder.util.dag.impl.DAGBuilderImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DAGTest {
    @Test
    public void testCycleException() {
        CycleDetectedException e = new CycleDetectedException("Test Message", new ArrayList());
        Assertions.assertFalse((e.getCycle() == null ? 1 : 0) != 0);
    }

    @Test
    public void testDAG() throws CycleDetectedException {
        DAGBuilderImpl.MutableDAGImpl dag = new DAGBuilderImpl.MutableDAGImpl();
        dag.addVertex((Comparable)((Object)"a"));
        MutableVertex v = dag.getVertex((Comparable)((Object)"a"));
        Assertions.assertFalse((boolean)v.equals("ABC"));
        Assertions.assertEquals((int)1, (int)dag.getVerticies().size());
        Assertions.assertEquals((Object)"a", (Object)dag.getVertex((Comparable)((Object)"a")).getLabel());
        dag.addVertex((Comparable)((Object)"a"));
        Assertions.assertEquals((int)1, (int)dag.getVerticies().size());
        Assertions.assertEquals((Object)"a", (Object)dag.getVertex((Comparable)((Object)"a")).getLabel());
        dag.addVertex((Comparable)((Object)"b"));
        Assertions.assertFalse((boolean)dag.getVertex((Comparable)((Object)"b")).isConnected());
        Assertions.assertFalse((boolean)dag.isConnected((Comparable)((Object)"b")));
        Assertions.assertEquals((int)2, (int)dag.getVerticies().size());
        Assertions.assertFalse((boolean)dag.hasEdge((Comparable)((Object)"a"), (Comparable)((Object)"b")));
        Assertions.assertFalse((boolean)dag.hasEdge((Comparable)((Object)"b"), (Comparable)((Object)"a")));
        MutableVertex a = dag.getVertex((Comparable)((Object)"a"));
        MutableVertex b = dag.getVertex((Comparable)((Object)"b"));
        Assertions.assertEquals((Object)"a", (Object)a.getLabel());
        Assertions.assertEquals((Object)"b", (Object)b.getLabel());
        dag.addEdge((Comparable)((Object)"a"), (Comparable)((Object)"b"));
        Assertions.assertTrue((boolean)dag.isConnected((Comparable)((Object)"b")));
        Assertions.assertTrue((boolean)a.getChildren().contains(b));
        Assertions.assertTrue((boolean)b.getParents().contains(a));
        Assertions.assertTrue((boolean)dag.hasEdge((Comparable)((Object)"a"), (Comparable)((Object)"b")));
        Assertions.assertFalse((boolean)dag.hasEdge((Comparable)((Object)"b"), (Comparable)((Object)"a")));
        dag.addEdge((Comparable)((Object)"c"), (Comparable)((Object)"d"));
        Assertions.assertEquals((int)4, (int)dag.getVerticies().size());
        MutableVertex c = dag.getVertex((Comparable)((Object)"c"));
        MutableVertex d = dag.getVertex((Comparable)((Object)"d"));
        Assertions.assertEquals((Object)"a", (Object)a.getLabel());
        Assertions.assertEquals((Object)"b", (Object)b.getLabel());
        Assertions.assertEquals((Object)"c", (Object)c.getLabel());
        Assertions.assertEquals((Object)"d", (Object)d.getLabel());
        Assertions.assertFalse((boolean)dag.hasEdge((Comparable)((Object)"b"), (Comparable)((Object)"a")));
        Assertions.assertFalse((boolean)dag.hasEdge((Comparable)((Object)"a"), (Comparable)((Object)"c")));
        Assertions.assertFalse((boolean)dag.hasEdge((Comparable)((Object)"a"), (Comparable)((Object)"d")));
        Assertions.assertTrue((boolean)dag.hasEdge((Comparable)((Object)"c"), (Comparable)((Object)"d")));
        Assertions.assertFalse((boolean)dag.hasEdge((Comparable)((Object)"d"), (Comparable)((Object)"c")));
        Set labels = dag.getLabels();
        Assertions.assertEquals((int)4, (int)labels.size());
        Assertions.assertTrue((boolean)labels.contains("a"));
        Assertions.assertTrue((boolean)labels.contains("b"));
        Assertions.assertTrue((boolean)labels.contains("c"));
        Assertions.assertTrue((boolean)labels.contains("d"));
        dag.addEdge((Comparable)((Object)"a"), (Comparable)((Object)"d"));
        Assertions.assertTrue((boolean)a.getChildren().contains(d));
        Assertions.assertTrue((boolean)d.getParents().contains(a));
        Assertions.assertEquals((int)2, (int)a.getChildren().size());
        Assertions.assertTrue((boolean)a.getChildLabels().contains("b"));
        Assertions.assertTrue((boolean)a.getChildLabels().contains("d"));
        Assertions.assertEquals((int)2, (int)d.getParents().size());
        Assertions.assertTrue((boolean)d.getParentLabels().contains("a"));
        Assertions.assertTrue((boolean)d.getParentLabels().contains("c"));
    }

    @Test
    public void testGetPredessors() throws CycleDetectedException {
        DAGBuilderImpl.MutableDAGImpl dag = new DAGBuilderImpl.MutableDAGImpl();
        dag.addEdge((Comparable)((Object)"a"), (Comparable)((Object)"b"));
        dag.addVertex((Comparable)((Object)"c"));
        dag.addVertex((Comparable)((Object)"d"));
        dag.addEdge((Comparable)((Object)"a"), (Comparable)((Object)"b"));
        dag.addEdge((Comparable)((Object)"b"), (Comparable)((Object)"c"));
        dag.addEdge((Comparable)((Object)"b"), (Comparable)((Object)"d"));
        dag.addEdge((Comparable)((Object)"c"), (Comparable)((Object)"d"));
        dag.addEdge((Comparable)((Object)"c"), (Comparable)((Object)"e"));
        dag.addEdge((Comparable)((Object)"f"), (Comparable)((Object)"d"));
        dag.addEdge((Comparable)((Object)"e"), (Comparable)((Object)"f"));
        dag.addEdge((Comparable)((Object)"f"), (Comparable)((Object)"g"));
        List actual = dag.getSuccessorLabels((Comparable)((Object)"b"));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("d");
        expected.add("g");
        expected.add("f");
        expected.add("e");
        expected.add("c");
        expected.add("b");
        Assertions.assertEquals(expected, (Object)actual);
    }
}

