/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.dag.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.infrastructurebuilder.util.dag.CycleDetectedException;
import org.infrastructurebuilder.util.dag.DAG;
import org.infrastructurebuilder.util.dag.DAGBuilder;
import org.infrastructurebuilder.util.dag.DAGVisitResult;
import org.infrastructurebuilder.util.dag.DAGVisitor;
import org.infrastructurebuilder.util.dag.DAGWalker;
import org.infrastructurebuilder.util.dag.MutableDAG;
import org.infrastructurebuilder.util.dag.MutableVertex;
import org.infrastructurebuilder.util.dag.Vertex;
import org.infrastructurebuilder.util.dag.impl.DAGBuilderImpl;
import org.infrastructurebuilder.util.dag.impl.DAGWalkerPreTraversalDepthFirstImpl;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DAGBuilderTest {
    private static final String FIVE = "5";
    private static final String FOUR = "4";
    private static final String ONE = "1";
    private static final String THREE = "3";
    private static final String TWO = "2";
    private DAG<String> b;
    private DAG<String> c;
    private DAG<String> d;
    private DAGBuilder<String> md;

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterAll
    public static void tearDownAfterClass() throws Exception {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.b = new DAGBuilderImpl().addEdge((Comparable)((Object)ONE), (Comparable)((Object)TWO)).addEdge((Comparable)((Object)TWO), (Comparable)((Object)THREE)).addEdge((Comparable)((Object)ONE), (Comparable)((Object)FOUR)).build();
        this.c = new DAGBuilderImpl(this.b).build();
        DAGBuilderImpl d1 = new DAGBuilderImpl(this.b);
        d1.addVertex((Comparable)((Object)FIVE));
        this.d = d1.build();
        this.md = new DAGBuilderImpl();
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testAddEdgeMutableVertexOfTMutableVertexOfT() throws CycleDetectedException {
        DAGBuilderImpl d1 = new DAGBuilderImpl(this.b);
        MutableVertex one = d1.addVertex((Comparable)((Object)ONE));
        MutableVertex two = d1.addVertex((Comparable)((Object)TWO));
        MutableVertex three = d1.addVertex((Comparable)((Object)THREE));
        MutableVertex four = d1.addVertex((Comparable)((Object)FOUR));
        d1.addEdge(one, two).addEdge(two, three).addEdge(one, four);
        DAG g = d1.build();
        Assertions.assertEquals(this.b, (Object)g);
        List<String> l = Arrays.asList(TWO, FOUR, TWO, FOUR);
        List k = g.getChildLabels((Comparable)((Object)ONE));
        Set m = g.getLabels();
        HashSet<String> expectedLab = new HashSet<String>(Arrays.asList(ONE, TWO, THREE, FOUR));
        Assertions.assertEquals(l, (Object)k);
        Assertions.assertEquals(expectedLab, (Object)m);
        List p = g.getParentLabels((Comparable)((Object)THREE));
        Assertions.assertEquals(Arrays.asList(TWO, TWO), (Object)p);
    }

    @Test
    public void testDAGBuilderDAGOfT() throws CycleDetectedException {
        Assertions.assertEquals(this.b, this.c);
        Assertions.assertNotEquals(this.b, this.d);
        Assertions.assertNotEquals(this.b, (Object)new DAGBuilderImpl(this.b).addEdge((Comparable)((Object)ONE), (Comparable)((Object)THREE)).build());
    }

    @Test
    public void testDAGImplEquals() throws CycleDetectedException {
        Assertions.assertEquals(this.b, this.b);
        Assertions.assertNotEquals(this.b, null);
        Assertions.assertNotEquals(this.b, (Object)"X");
        DAGBuilderImpl d1 = new DAGBuilderImpl();
        MutableVertex one = d1.addVertex((Comparable)((Object)ONE));
        MutableVertex two = d1.addVertex((Comparable)((Object)TWO));
        MutableVertex three = d1.addVertex((Comparable)((Object)THREE));
        DAGBuilderImpl d2 = new DAGBuilderImpl();
        d2.addVertex((Comparable)((Object)ONE));
        d2.addVertex((Comparable)((Object)TWO));
        d2.addVertex((Comparable)((Object)THREE));
        d2.addVertex((Comparable)((Object)FOUR));
        Assertions.assertNotEquals((Object)d2.build(), (Object)d1.build());
        DAG dag2 = d1.build();
        MutableVertex four = d1.addVertex((Comparable)((Object)FOUR));
        d1.addEdge(one, two).addEdge(two, three).addEdge(one, four).addEdge(two, four);
        d1.addEdge((Comparable)((Object)FIVE), (Comparable)((Object)TWO));
        DAG d2d = d2.build();
        DAG d1d = d1.build();
        d1d.equals(d2d);
        Assertions.assertNotEquals((Object)dag2, (Object)d1.build());
    }

    @Test
    public void testDagNotequals1() throws CycleDetectedException {
        DAGBuilderImpl d1 = new DAGBuilderImpl();
        d1.addVertex((Comparable)((Object)ONE));
        d1.addVertex((Comparable)((Object)TWO));
        d1.addVertex((Comparable)((Object)THREE));
        DAGBuilderImpl d2 = new DAGBuilderImpl();
        d2.addVertex((Comparable)((Object)ONE));
        d2.addVertex((Comparable)((Object)TWO));
        d2.addVertex((Comparable)((Object)FOUR));
        DAGBuilderImpl.MutableDAGImpl s1 = new DAGBuilderImpl.MutableDAGImpl((MutableDAG)new DAGBuilderImpl.MutableDAGImpl(d1.build()));
        DAGBuilderImpl.MutableDAGImpl s2 = new DAGBuilderImpl.MutableDAGImpl(d2.build());
        Assertions.assertNotEquals((Object)s1, (Object)s2);
        d2.addVertex((Comparable)((Object)THREE));
        s2 = new DAGBuilderImpl.MutableDAGImpl(d2.build());
        Assertions.assertNotEquals((Object)s1, (Object)s2);
    }

    @Test
    public void testHasEdge() {
        Assertions.assertTrue((boolean)this.d.hasEdge((Comparable)((Object)ONE), (Comparable)((Object)TWO)));
        Assertions.assertFalse((boolean)this.d.hasEdge((Comparable)((Object)ONE), (Comparable)((Object)FIVE)));
    }

    @Test
    public void testHash() {
        Assertions.assertTrue((this.md.build().hashCode() != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveEdgeMutableVertexOfTMutableVertexOfT() throws CycleDetectedException {
        DAGBuilderImpl d1 = new DAGBuilderImpl(this.b);
        MutableVertex one = d1.addVertex((Comparable)((Object)ONE));
        MutableVertex two = d1.addVertex((Comparable)((Object)TWO));
        MutableVertex three = d1.addVertex((Comparable)((Object)THREE));
        MutableVertex four = d1.addVertex((Comparable)((Object)FOUR));
        d1.addEdge(one, two).addEdge(two, three).addEdge(one, four).addEdge(two, four);
        d1.removeEdge(two, four);
        Assertions.assertEquals(this.b, (Object)d1.build());
    }

    @Test
    public void testRemoveEdgeTT() throws CycleDetectedException {
        DAGBuilderImpl d1 = new DAGBuilderImpl(this.b);
        MutableVertex one = d1.addVertex((Comparable)((Object)ONE));
        MutableVertex two = d1.addVertex((Comparable)((Object)TWO));
        MutableVertex three = d1.addVertex((Comparable)((Object)THREE));
        MutableVertex four = d1.addVertex((Comparable)((Object)FOUR));
        Assertions.assertFalse((boolean)four.isRoot());
        Assertions.assertTrue((boolean)four.toString().startsWith("Vertex{label="));
        Assertions.assertFalse((four.getChildLabels().size() > 0 ? 1 : 0) != 0);
        d1.addEdge(one, two).addEdge(two, three).addEdge(one, four).addEdge(two, four);
        d1.removeEdge((Comparable)((Object)TWO), (Comparable)((Object)FOUR));
        Assertions.assertEquals(this.b, (Object)d1.build());
    }

    @Test
    public void testSortTT() throws CycleDetectedException {
        DAGBuilderImpl d1 = new DAGBuilderImpl(this.b);
        MutableVertex one = d1.addVertex((Comparable)((Object)ONE));
        MutableVertex two = d1.addVertex((Comparable)((Object)TWO));
        MutableVertex three = d1.addVertex((Comparable)((Object)THREE));
        MutableVertex four = d1.addVertex((Comparable)((Object)FOUR));
        d1.addEdge(one, two).addEdge(two, three).addEdge(one, four).addEdge(two, four);
        DAGBuilderImpl.MutableDAGImpl.DAGImpl.DepthFirstTopologicalSorterImpl s = new DAGBuilderImpl.MutableDAGImpl.DAGImpl.DepthFirstTopologicalSorterImpl();
        List a = s.sort(d1.build());
        Assertions.assertEquals(Arrays.asList(THREE, FOUR, TWO, ONE), (Object)a);
    }

    @Test
    public void testVertexImplEquals() throws CycleDetectedException {
        DAGBuilderImpl d1 = new DAGBuilderImpl();
        DAGBuilderImpl d2 = new DAGBuilderImpl();
        d2.addVertex((Comparable)((Object)ONE));
        d2.addVertex((Comparable)((Object)TWO));
        d2.addVertex((Comparable)((Object)THREE));
        d2.addVertex((Comparable)((Object)FOUR));
        Assertions.assertNotEquals((Object)d2.build(), (Object)d1.build());
        d1.addVertex((Comparable)((Object)TWO));
        DAG dag1 = d1.build();
        DAG dag2 = d2.build();
        Vertex v2 = dag2.getVertex((Comparable)((Object)TWO));
        Assertions.assertEquals((Object)"Vertex{label='2'}", (Object)v2.toString());
        Assertions.assertTrue((boolean)v2.isRoot());
        Assertions.assertTrue((boolean)v2.isLeaf());
        Assertions.assertNotNull((Object)UUID.fromString(v2.getId()));
        Assertions.assertFalse((boolean)v2.equals(null));
        Vertex v1 = dag1.getVertex((Comparable)((Object)TWO));
        Assertions.assertEquals((Object)v1, (Object)v2);
    }

    @Test
    public void testWalkMutable() throws CycleDetectedException {
        DAGBuilderImpl d1 = new DAGBuilderImpl();
        d1.addVertex((Comparable)((Object)ONE));
        d1.addVertex((Comparable)((Object)TWO));
        d1.addVertex((Comparable)((Object)THREE));
        DAGBuilderImpl d2 = new DAGBuilderImpl();
        d2.addVertex((Comparable)((Object)ONE));
        d2.addVertex((Comparable)((Object)TWO));
        d2.addVertex((Comparable)((Object)FOUR));
        new DAGBuilderImpl.MutableDAGImpl((MutableDAG)new DAGBuilderImpl.MutableDAGImpl(d1.build()));
        final ArrayList collected = new ArrayList();
        DAGVisitor<String> v = new DAGVisitor<String>(){

            public DAGVisitResult visitNode(Vertex<String> node) {
                collected.add((String)((Object)node.getLabel()));
                return DAGVisitResult.SKIP_SIBLINGS;
            }
        };
        List<DAGVisitor> visitors = Arrays.asList(v);
        d1.build().walk((DAGWalker)new DAGWalkerPreTraversalDepthFirstImpl(), visitors);
        Assertions.assertEquals((int)1, (int)visitors.size());
    }
}

