/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.dag.impl;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.infrastructurebuilder.util.dag.CycleDetectedException;
import org.infrastructurebuilder.util.dag.MutableDAG;
import org.infrastructurebuilder.util.dag.MutableVertex;
import org.infrastructurebuilder.util.dag.impl.DAGBuilderImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DAG2UUIDTest {
    private UUID a;
    private UUID b;
    private UUID c;
    private UUID d;
    private UUID e;
    private MutableDAG<UUID> dag;
    private MutableDAG<UUID> dag1;
    private MutableDAG<UUID> dag2;
    private MutableVertex<UUID> dV;
    MutableVertex<UUID> cV;

    @BeforeEach
    public void setUp() throws Exception {
        this.a = UUID.randomUUID();
        this.b = UUID.randomUUID();
        this.c = UUID.randomUUID();
        this.d = UUID.randomUUID();
        this.e = UUID.randomUUID();
        this.dag = new DAGBuilderImpl.MutableDAGImpl();
        this.dag1 = new DAGBuilderImpl.MutableDAGImpl();
        this.dag1.addEdge((Comparable)this.a, (Comparable)this.b);
        this.dag1.addVertex((Comparable)this.c);
        this.dag1.addEdge((Comparable)this.c, (Comparable)this.a);
        this.dag1.addEdge((Comparable)this.c, (Comparable)this.b);
        this.dag1.addEdge((Comparable)this.a, (Comparable)this.d);
        this.dag1.addEdge((Comparable)this.b, (Comparable)this.d);
        this.dag2 = new DAGBuilderImpl.MutableDAGImpl();
        this.dag2.addEdge((Comparable)this.a, (Comparable)this.b);
        this.dag2.addVertex((Comparable)this.c);
        this.dag2.addEdge((Comparable)this.c, (Comparable)this.a);
        this.dag2.addEdge((Comparable)this.c, (Comparable)this.b);
        this.dag2.addEdge((Comparable)this.a, (Comparable)this.d);
        this.dag2.addEdge((Comparable)this.b, (Comparable)this.d);
    }

    @Test
    public final void testAddEdgeVertexOfTVertexOfT() throws CycleDetectedException {
        this.cV = this.dag1.getVertex((Comparable)this.c);
        this.dV = this.dag1.getVertex((Comparable)this.d);
        Assertions.assertThrows(CycleDetectedException.class, () -> this.dag1.addEdge(this.dV, this.cV));
    }

    @Test
    public final void testAddEdgeVertexOfTVertexOfTCaughtCheckMessage() {
        this.cV = this.dag1.getVertex((Comparable)this.c);
        this.dV = this.dag1.getVertex((Comparable)this.d);
        try {
            this.dag1.addEdge(this.dV, this.cV);
        }
        catch (CycleDetectedException e) {
            String msg2 = e.getMessage();
            Assertions.assertTrue((boolean)msg2.contains(this.c.toString()), (String)"Message has c id");
            Assertions.assertTrue((boolean)msg2.contains(this.d.toString()), (String)"Message has d id");
            String message = e.cycleToString();
            this.c.toString();
            this.d.toString();
            Assertions.assertTrue((boolean)message.contains(this.c.toString()), (String)"Message has c id");
            Assertions.assertTrue((boolean)message.contains(this.d.toString()), (String)"Message has d id");
        }
    }

    @Test
    public final void testEquals() throws CycleDetectedException {
        Assertions.assertEquals(this.dag1, this.dag1);
        Assertions.assertNotEquals(this.dag1, null);
        Assertions.assertNotEquals(this.dag1, (Object)"A");
        Assertions.assertEquals(this.dag1, this.dag2);
        DAGBuilderImpl.MutableDAGImpl dag3 = new DAGBuilderImpl.MutableDAGImpl();
        dag3.addVertex((Comparable)this.a);
        dag3.addVertex((Comparable)this.b);
        dag3.addEdge((Comparable)this.c, (Comparable)this.d);
    }

    @Test
    public final void testGetChildLabels() {
        List l = this.dag1.getChildLabels((Comparable)this.a);
        Assertions.assertEquals((int)2, (int)l.size());
        Assertions.assertTrue((l.contains(this.b) && l.contains(this.d) ? 1 : 0) != 0);
    }

    @Test
    public final void testGetLabels() {
        Set l = this.dag.getLabels();
        Set l1 = this.dag1.getLabels();
        Assertions.assertEquals((int)0, (int)l.size());
        Assertions.assertEquals((int)4, (int)l1.size());
        Assertions.assertTrue((boolean)l1.contains(this.d));
    }

    @Test
    public final void testGetParentLabels() {
        List l = this.dag1.getParentLabels((Comparable)this.d);
        Assertions.assertTrue((boolean)l.contains(this.a));
        Assertions.assertEquals((int)2, (int)l.size());
        this.dag1.addVertex((Comparable)this.e);
        Assertions.assertEquals((int)0, (int)this.dag1.getParentLabels((Comparable)this.e).size());
    }

    @Test
    public final void testGetSuccessorLabels() {
        List z = this.dag1.getSuccessorLabels((Comparable)this.a);
        Assertions.assertEquals((int)3, (int)z.size());
        z = this.dag1.getSuccessorLabels((Comparable)this.d);
        Assertions.assertTrue((boolean)z.contains(this.d));
        Assertions.assertEquals((int)1, (int)z.size());
    }

    @Test
    public final void testGetVerticies() {
        Assertions.assertEquals((int)0, (int)this.dag.getVerticies().size());
        Assertions.assertEquals((int)4, (int)this.dag1.getVerticies().size());
        Assertions.assertFalse((boolean)this.dag1.getVerticies().stream().map(v -> (UUID)v.getLabel()).collect(Collectors.toSet()).contains(this.e));
    }

    @Test
    public final void testHasEdge() {
        Assertions.assertFalse((boolean)this.dag.hasEdge((Comparable)this.b, (Comparable)this.d));
        Assertions.assertTrue((boolean)this.dag1.hasEdge((Comparable)this.b, (Comparable)this.d));
    }

    @Test
    public final void testHash() {
        Assertions.assertEquals((int)961, (int)this.dag.hashCode());
    }

    @Test
    public final void testIsConnected() throws CloneNotSupportedException {
        this.dag2.addVertex((Comparable)this.e);
        Assertions.assertTrue((boolean)this.dag2.isConnected((Comparable)this.c));
        Assertions.assertTrue((boolean)this.dag2.isConnected((Comparable)this.a));
        Assertions.assertFalse((boolean)this.dag2.isConnected((Comparable)this.e));
    }

    @Test
    public final void testIsRoot() {
        this.dag1.addVertex((Comparable)this.e);
        Assertions.assertTrue((boolean)this.dag1.getVertex((Comparable)this.c).isRoot());
        Assertions.assertTrue((boolean)this.dag1.getVertex((Comparable)this.e).isRoot());
        Assertions.assertFalse((boolean)this.dag1.getVertex((Comparable)this.a).isRoot());
    }

    @Test
    public final void testRemoveEdgeTT() {
        Assertions.assertTrue((boolean)this.dag1.hasEdge((Comparable)this.a, (Comparable)this.b));
        this.dag1.removeEdge((Comparable)this.a, (Comparable)this.b);
        Assertions.assertFalse((boolean)this.dag1.hasEdge((Comparable)this.a, (Comparable)this.b));
    }

    @Test
    public final void testSortEntireGraph() throws CloneNotSupportedException {
        this.dag2.addVertex((Comparable)this.e);
        List z = new DAGBuilderImpl.MutableDAGImpl.MutableTopologicalSorterImpl().sort(this.dag2);
        Assertions.assertEquals((int)5, (int)z.size());
    }

    @Test
    public final void testVertexEquals() throws CycleDetectedException {
        this.cV = this.dag1.getVertex((Comparable)this.c);
        Assertions.assertEquals(this.cV, this.cV);
        Assertions.assertNotEquals(this.cV, null);
        Assertions.assertNotEquals(this.cV, (Object)"abc");
        DAGBuilderImpl.MutableDAGImpl.MutableVertexImpl c1V = new DAGBuilderImpl.MutableDAGImpl.MutableVertexImpl(this.cV.getLabel(), new DAGBuilderImpl.MutableDAGImpl.MutableTopologicalSorterImpl());
        Assertions.assertNotEquals((Object)c1V, this.cV);
        Assertions.assertEquals((Object)this.dag1.getVertex((Comparable)this.c), (Object)this.dag2.getVertex((Comparable)this.c));
        DAGBuilderImpl.MutableDAGImpl dag4 = new DAGBuilderImpl.MutableDAGImpl();
        dag4.addEdge((Comparable)this.a, (Comparable)this.b);
        dag4.addVertex((Comparable)this.c);
        dag4.addEdge((Comparable)this.c, (Comparable)this.a);
        dag4.addEdge((Comparable)this.c, (Comparable)this.b);
        dag4.addEdge((Comparable)this.a, (Comparable)this.d);
        dag4.addEdge((Comparable)this.b, (Comparable)this.d);
        dag4.addEdge((Comparable)this.e, (Comparable)this.c);
        Assertions.assertNotEquals((Object)this.dag1.getVertex((Comparable)this.c), (Object)dag4.getVertex((Comparable)this.c));
    }
}

