/*
 * @formatter:off
 * Copyright © 2019 admin (admin@infrastructurebuilder.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * @formatter:on
 */
package org.infrastructurebuilder.util.dag;

import java.util.List;
import java.util.StringJoiner;

public class CycleDetectedException extends Exception {

  /**
   *
   */
  private static final long serialVersionUID = -362151475890105972L;
  private final List<?> cycle;

  public CycleDetectedException(final String message, final List<?> cycle) {
    super(message);

    this.cycle = cycle;

  }

  public String cycleToString() {
    final StringJoiner sj = new StringJoiner(" --> ");
    cycle.stream().forEach(j -> sj.add(j.toString()));
    return sj.toString();
  }

  public List<?> getCycle() {
    return cycle;
  }

  @Override
  public String getMessage() {
    return super.getMessage() + " " + cycleToString();
  }
}
