/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.dag;

import java.util.List;
import java.util.StringJoiner;

public class CycleDetectedException
extends Exception {
    private static final long serialVersionUID = -362151475890105972L;
    private final List<?> cycle;

    public CycleDetectedException(String message, List<?> cycle) {
        super(message);
        this.cycle = cycle;
    }

    public String cycleToString() {
        StringJoiner sj = new StringJoiner(" --> ");
        this.cycle.stream().forEach(j -> sj.add(j.toString()));
        return sj.toString();
    }

    public List<?> getCycle() {
        return this.cycle;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + " " + this.cycleToString();
    }
}

