/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataSet;
import org.infrastructurebuilder.data.IBDataTypeImplsModelUtils;
import org.infrastructurebuilder.util.config.TestingPathSupplier;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.infrastructurebuilder.util.files.model.IBCPTInputSource;
import org.infrastructurebuilder.util.files.model.io.xpp3.IBChecksumPathTypeModelXpp3ReaderEx;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;

public class InjectIBData
implements ParameterResolver {
    private static final Logger log = LoggerFactory.getLogger(InjectIBData.class);
    private static final TestingPathSupplier wps = new TestingPathSupplier();
    private static final IBChecksumPathTypeModelXpp3ReaderEx reader = new IBChecksumPathTypeModelXpp3ReaderEx();
    public static final Function<Path, ? extends IBChecksumPathType> readIBCPT = marker -> {
        try (InputStream in = Files.newInputStream(marker, LinkOption.NOFOLLOW_LINKS);){
            IBChecksumPathType iBChecksumPathType = (IBChecksumPathType)IBDataException.cet.withReturningTranslation(() -> reader.read(in, true, new IBCPTInputSource()));
            return iBChecksumPathType;
        }
        catch (IOException e) {
            throw new IBDataException("Marker file " + marker.toString() + " invalid", (Throwable)e);
        }
    };

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().equals(IBDataSet.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        IBChecksumPathType v = readIBCPT.apply(wps.getRoot().resolve(".ibdatamarker.xml").toAbsolutePath());
        URL u = (URL)IBDataException.cet.withReturningTranslation(() -> v.getPath().resolve("IBDATA-INF").resolve("ibdataset.xml").toUri().toURL());
        log.debug(() -> "About to read " + u.toExternalForm());
        return ((Optional)IBDataTypeImplsModelUtils.mapDataSetToDefaultIBDataSet.apply(u)).orElseThrow(() -> new IBDataException("No ingestion or transformation available for " + v.getPath()));
    }
}

