/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Function;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataSet;
import org.infrastructurebuilder.data.IBDataTypeImplsModelUtils;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.infrastructurebuilder.util.files.model.IBCPTInputSource;
import org.infrastructurebuilder.util.files.model.io.xpp3.IBChecksumPathTypeModelXpp3ReaderEx;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;

public class InjectIBData
implements ParameterResolver {
    public static final Function<? super InputStream, ? extends IBChecksumPathType> readIBCPT = in -> {
        IBChecksumPathTypeModelXpp3ReaderEx reader = new IBChecksumPathTypeModelXpp3ReaderEx();
        IBCPTInputSource dsis = new IBCPTInputSource();
        return (IBChecksumPathType)IBDataException.cet.withReturningTranslation(() -> reader.read(in, true, dsis));
    };
    public static final Logger log = LoggerFactory.getLogger(InjectIBData.class);

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().equals(IBDataSet.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        IBChecksumPathType v = this.getMarkerFile();
        URL u = (URL)IBDataException.cet.withReturningTranslation(() -> v.getPath().resolve("IBDATA-INF").resolve("ibdataset.xml").toUri().toURL());
        log.info(() -> "About to read " + u.toExternalForm());
        return ((Optional)IBDataTypeImplsModelUtils.mapDataSetToDefaultIBDataSet.apply(u)).orElseThrow(() -> new IBDataException("No ingestion or transformation available for " + v.getPath()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IBChecksumPathType getMarkerFile() {
        Path marker = Paths.get(Optional.ofNullable(System.getProperties().getProperty("target_dir")).orElseThrow(() -> new IBDataException("Cannot locate marker file")), new String[0]).resolve(".ibdatamarker.xml").toAbsolutePath();
        OpenOption[] options = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        try (InputStream ins = Files.newInputStream(marker, options);){
            IBChecksumPathType v;
            IBChecksumPathType iBChecksumPathType = v = readIBCPT.apply(ins);
            return iBChecksumPathType;
        }
        catch (IOException e) {
            throw new IBDataException("Marker file " + marker.toString() + " invalid", (Throwable)e);
        }
    }
}

