/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataSet;
import org.infrastructurebuilder.data.IBDataTypeImplsModelUtils;
import org.infrastructurebuilder.util.IBUtils;
import org.infrastructurebuilder.util.files.BasicIBChecksumPathType;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;

public class InjectIBData
implements ParameterResolver {
    public static final Logger log = LoggerFactory.getLogger(InjectIBData.class);

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().equals(IBDataSet.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        BasicIBChecksumPathType v;
        Path workingPath = Paths.get(Optional.ofNullable(System.getProperties().getProperty("ibdata.working.directory")).orElse("./target/ibdata"), new String[0]).toAbsolutePath();
        Path marker = this.getMarkerFile(workingPath).orElseThrow(() -> new IBDataException("No marker file found for " + workingPath.toString()));
        try {
            v = new BasicIBChecksumPathType(new JSONObject(IBUtils.readFile((Path)marker)));
        }
        catch (IOException | JSONException e) {
            throw new IBDataException("Marker file " + marker.toString() + " invalid", e);
        }
        URL u = (URL)IBDataException.cet.withReturningTranslation(() -> InjectIBData.lambda$resolveParameter$1((IBChecksumPathType)v));
        log.info(() -> "About to read " + u.toExternalForm());
        return ((Optional)IBDataTypeImplsModelUtils.mapDataSetToDefaultIBDataSet.apply(u)).orElseThrow(() -> new IBDataException("No ingestion or transformation available for " + marker.toString()));
    }

    private Optional<Path> getMarkerFile(Path workingPath) {
        LinkOption[] options = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        Path marker = workingPath.resolve("IBDATA_INGESTION_TARGET_@3123.json");
        if (!Files.isRegularFile(marker, options)) {
            marker = workingPath.resolve("IBDATA_TRANSFORMATION_TARGET_@3123.json");
        }
        if (!Files.isRegularFile(marker, options)) {
            marker = null;
        }
        return Optional.ofNullable(marker);
    }

    private static /* synthetic */ URL lambda$resolveParameter$1(IBChecksumPathType v) throws Exception {
        return v.getPath().resolve("IBDATA-INF").resolve("ibdataset.xml").toUri().toURL();
    }
}

