/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.transform;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.infrastructurebuilder.data.AbstractIBDataMojo;
import org.infrastructurebuilder.data.IBDataModelUtils;
import org.infrastructurebuilder.data.transform.IBDataTransformMavenComponent;
import org.infrastructurebuilder.data.transform.Transformation;
import org.infrastructurebuilder.util.files.IBChecksumPathType;

@Mojo(name="transform", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class IBDataTransformMojo
extends AbstractIBDataMojo {
    @Parameter(required=true)
    private List<Transformation> transformations = new ArrayList<Transformation>();
    @Parameter(required=false, property="ibdata.injectDependencies")
    private boolean injectDependencies = false;
    @Component
    IBDataTransformMavenComponent component;

    @Override
    protected IBDataTransformMavenComponent getComponent() {
        return this.component;
    }

    @Override
    protected void _execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<URL> l = new ArrayList<URL>();
        if (this.injectDependencies) {
            try {
                List myList = this.getProject().getCompileClasspathElements().stream().map(x -> Paths.get(x.toString(), new String[0])).collect(Collectors.toList());
                for (Path ff : myList) {
                    l.add(ff.toUri().toURL());
                }
            }
            catch (MalformedURLException | DependencyResolutionRequiredException e) {
                throw new MojoFailureException("Failed to acquire additional URLS", e);
            }
        }
        this.component.setAdditionalURLS(l);
        IBChecksumPathType theResult = this.component.transform(this.transformations);
        this.getLog().debug((CharSequence)"Setting plugin context");
        Map pc = this.getPluginContext();
        if (pc.containsKey("IBDATA_INGESTION_TARGET_@3123")) {
            throw new MojoFailureException("Transformation and Ingestion cannot be performed in the same module build.");
        }
        this.setPluginContext(pc);
        this.getLog().debug((CharSequence)("Class of the results is " + theResult.getClass()));
        Path p = this.writeMarker(IBDataModelUtils.remodel((IBChecksumPathType)theResult)).toAbsolutePath();
        this.getLog().debug((CharSequence)("Marker written to " + p));
        pc.put("IBDATA_TRANSFORMATION_TARGET_@3123", theResult);
        this.getLog().debug((CharSequence)"plugin context set");
        this.getLog().info((CharSequence)("Data transformations complete with " + theResult.getPath() + " as " + theResult.getChecksum()));
    }
}

