/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import java.nio.file.Path;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.infrastructurebuilder.data.AbstractIBDataMojo;
import org.infrastructurebuilder.data.IBDataModelUtils;
import org.infrastructurebuilder.data.ingest.IBDataIngestMavenComponent;
import org.infrastructurebuilder.data.ingest.Ingestion;
import org.infrastructurebuilder.util.files.IBChecksumPathType;

@Mojo(name="ingest", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=true)
public class IBDataIngestMojo
extends AbstractIBDataMojo {
    @Parameter(required=true)
    private Ingestion ingest;
    @Component
    IBDataIngestMavenComponent component;

    @Override
    protected IBDataIngestMavenComponent getComponent() {
        return this.component;
    }

    @Override
    public void _execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Attempting Data Ingestion");
        Map pc = this.getPluginContext();
        if (pc.containsKey("IBDATA_TRANSFORMATION_TARGET_@3123")) {
            throw new MojoFailureException("Transformation and Ingestion cannot be performed in the same module build.");
        }
        IBChecksumPathType theResult = this.component.ingest(this.ingest);
        this.getLog().debug((CharSequence)("Class of the results is " + theResult.getClass()));
        Path p = this.writeMarker(IBDataModelUtils.remodel((IBChecksumPathType)theResult));
        this.getLog().debug((CharSequence)("Marker written to " + p));
        pc.put("IBDATA_INGESTION_TARGET_@3123", theResult);
        this.setPluginContext(pc);
        this.getLog().info((CharSequence)("Data ingestion is complete with " + theResult.getPath() + " as " + theResult.getChecksum()));
    }
}

