/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.infrastructurebuilder.data.AbstractIBDataMavenComponent;
import org.infrastructurebuilder.data.IBDataIngester;
import org.infrastructurebuilder.data.IBDataIngesterSupplier;
import org.infrastructurebuilder.data.IBDataSetFinalizer;
import org.infrastructurebuilder.data.IBDataSetFinalizerSupplier;
import org.infrastructurebuilder.data.IBStreamerFactory;
import org.infrastructurebuilder.data.ingest.IBDataSourceSupplierFactory;
import org.infrastructurebuilder.data.ingest.Ingestion;
import org.infrastructurebuilder.util.config.ConfigMapSupplier;
import org.infrastructurebuilder.util.config.PathSupplier;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.infrastructurebuilder.util.files.TypeToExtensionMapper;

@Named(value="ingest")
public final class IBDataIngestMavenComponent
extends AbstractIBDataMavenComponent {
    private final Map<String, IBDataIngesterSupplier> allIngesters;
    private final IBDataSourceSupplierFactory dsSupplierFactory;

    @Inject
    public IBDataIngestMavenComponent(@Named(value="ibdata-working-path-supplier") PathSupplier workingPathSupplier, Log log, TypeToExtensionMapper defaultTypeToExtensionMapper, @Named(value="maven") ConfigMapSupplier mavenConfigMapSupplier, Map<String, IBDataIngesterSupplier> allIngesters, Map<String, IBDataSetFinalizerSupplier<?>> allDSFinalizers, IBStreamerFactory streamerFactory, IBDataSourceSupplierFactory ibdssf) {
        super(workingPathSupplier, log, defaultTypeToExtensionMapper, mavenConfigMapSupplier, allDSFinalizers, streamerFactory);
        this.allIngesters = Objects.requireNonNull(allIngesters);
        this.dsSupplierFactory = Objects.requireNonNull(ibdssf);
    }

    public IBChecksumPathType ingest(Ingestion ingest) throws MojoFailureException {
        IBDataSetFinalizer<?> finalizer;
        MavenProject p = this.getProject().orElseThrow(() -> new MojoFailureException("No supplied project"));
        Objects.requireNonNull(ingest).getDataSet().injectGAV(p.getGroupId(), p.getArtifactId(), p.getVersion());
        try {
            finalizer = this.getDataSetFinalizerSupplier(ingest.getFinalizer(), ingest.getFinalizerConfig());
        }
        catch (ClassCastException e) {
            throw new MojoFailureException("Finalizer " + ingest.getFinalizer() + " was not considered viable", (Throwable)e);
        }
        IBDataIngesterSupplier i = (IBDataIngesterSupplier)Optional.ofNullable(Objects.requireNonNull(ingest).getIngester()).flatMap(j -> Optional.ofNullable(this.allIngesters.get(j))).orElseThrow(() -> new MojoFailureException("No ingester named " + ingest.getIngester()));
        List suppliers = ((IBDataIngester)i.configure((Object)this.getConfigMapSupplier()).get()).ingest(this.dsSupplierFactory.mapIngestionToSourceSuppliers(ingest));
        try {
            return finalizer.finalize(null, (Object)ingest, suppliers, this.getBaseDir());
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to finalize", (Throwable)e);
        }
    }
}

