/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import com.mscharhag.et.ReturningTryBlock;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.infrastructurebuilder.data.AbstractIBDataSource;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataSource;
import org.infrastructurebuilder.data.IBDataSourceSupplier;
import org.infrastructurebuilder.data.IBDataStreamIdentifier;
import org.infrastructurebuilder.data.ingest.AbstractIBDataSourceSupplierMapper;
import org.infrastructurebuilder.data.ingest.WGetter;
import org.infrastructurebuilder.data.ingest.WGetterSupplier;
import org.infrastructurebuilder.util.BasicCredentials;
import org.infrastructurebuilder.util.IBUtils;
import org.infrastructurebuilder.util.LoggerSupplier;
import org.infrastructurebuilder.util.artifacts.Checksum;
import org.infrastructurebuilder.util.config.ConfigMap;
import org.infrastructurebuilder.util.config.PathSupplier;
import org.infrastructurebuilder.util.files.DefaultIBChecksumPathType;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.infrastructurebuilder.util.files.TypeToExtensionMapper;
import org.slf4j.Logger;
import org.w3c.dom.Document;

@Named
public class DefaultIBDataSourceSupplierMapper
extends AbstractIBDataSourceSupplierMapper {
    public static final List<String> HEADERS = Arrays.asList("http://", "https://", "file:", "zip:", "jar:");
    private final WGetterSupplier wgs;
    private final ArchiverManager archiverManager;

    @Inject
    public DefaultIBDataSourceSupplierMapper(LoggerSupplier l, TypeToExtensionMapper t2e, WGetterSupplier wgs, ArchiverManager am, @Named(value="ibdata-working-path-supplier") PathSupplier workingPathSupplier) {
        super((Logger)Objects.requireNonNull(l).get(), Objects.requireNonNull(t2e), workingPathSupplier);
        this.wgs = Objects.requireNonNull(wgs);
        this.archiverManager = Objects.requireNonNull(am);
    }

    public List<String> getHeaders() {
        return HEADERS;
    }

    public IBDataSourceSupplier getSupplierFor(String temporaryId, IBDataStreamIdentifier v) {
        return new AbstractIBDataSourceSupplierMapper.DefaultIBDataSourceSupplier((AbstractIBDataSourceSupplierMapper)this, temporaryId, (IBDataSource)new DefaultIBDataSource(this.getLog(), (String)v.getURL().orElseThrow(() -> new IBDataException("No url for " + temporaryId)), v.isExpandArchives(), v.getName(), v.getDescription(), Optional.ofNullable(v.getChecksum()), Optional.of(v.getMetadataAsDocument()), Optional.ofNullable(v.getMimeType()), this.wgs, this.archiverManager, this.getMapper()), this.getWorkingPath());
    }

    public class DefaultIBDataSource
    extends AbstractIBDataSource {
        private final Path targetPath;
        private final Optional<String> mimeType;
        private final WGetterSupplier wgs;
        private final ArchiverManager am;
        private final TypeToExtensionMapper mapper;
        private List<IBChecksumPathType> read;

        private DefaultIBDataSource(Logger log, String id, String sourceUrl, boolean expandArchives, Optional<BasicCredentials> creds, Optional<Checksum> checksum, Optional<Document> metadata, Optional<ConfigMap> additionalConfig, Path targetPath, Optional<String> name, Optional<String> description, Optional<String> mimeType, WGetterSupplier wgs, ArchiverManager am, TypeToExtensionMapper mapper) {
            super(log, id, sourceUrl, expandArchives, name, description, creds, checksum, metadata, additionalConfig);
            this.targetPath = targetPath;
            this.mimeType = mimeType;
            this.wgs = Objects.requireNonNull(wgs);
            this.am = Objects.requireNonNull(am);
            this.mapper = Objects.requireNonNull(mapper);
        }

        public DefaultIBDataSource(Logger log, String source, boolean expandArchives, Optional<String> name, Optional<String> description, Optional<Checksum> checksum, Optional<Document> metadata, Optional<String> targetType, WGetterSupplier wgs, ArchiverManager am, TypeToExtensionMapper mapper) {
            this(log, UUID.randomUUID().toString(), source, expandArchives, Optional.empty(), checksum, metadata, Optional.empty(), null, name, description, targetType, wgs, am, mapper);
        }

        public IBDataSource withAdditionalConfig(ConfigMap config) {
            return new DefaultIBDataSource(this.getLog(), this.getId(), this.getSourceURL(), this.isExpandArchives(), this.getCredentials(), this.getChecksum(), this.getMetadata(), Optional.of(config), DefaultIBDataSourceSupplierMapper.this.getWorkingPath(), this.getName(), this.getDescription(), this.getMimeType(), this.wgs, this.am, this.mapper);
        }

        public Optional<String> getMimeType() {
            return this.mimeType;
        }

        public List<IBChecksumPathType> get() {
            return Optional.ofNullable(this.targetPath).map(this::lambda$get$2).orElse(Collections.emptyList());
        }

        /*
         * Unable to fully structure code
         */
        private /* synthetic */ List lambda$get$2(Path target) {
            block25: {
                if (this.read != null) break block25;
                src = IBUtils.translateToWorkableArchiveURL((String)this.source);
                wget = (WGetter)this.wgs.get();
                var5_4 = src.getProtocol();
                var6_5 = -1;
                switch (var5_4.hashCode()) {
                    case 3213448: {
                        if (!var5_4.equals("http")) break;
                        var6_5 = 0;
                        break;
                    }
                    case 99617003: {
                        if (!var5_4.equals("https")) break;
                        var6_5 = 1;
                        break;
                    }
                    case 3143036: {
                        if (!var5_4.equals("file")) break;
                        var6_5 = 2;
                        break;
                    }
                    case 120609: {
                        if (!var5_4.equals("zip")) break;
                        var6_5 = 3;
                        break;
                    }
                    case 104987: {
                        if (!var5_4.equals("jar")) break;
                        var6_5 = 4;
                    }
                }
                switch (var6_5) {
                    case 0: 
                    case 1: {
                        localRead = (List)wget.collectCacheAndCopyToChecksumNamedFile(false, this.getCredentials(), this.targetPath, src.toExternalForm(), this.checksum, this.mimeType, 3, 0, false, this.isExpandArchives()).orElseThrow((Supplier<IBDataException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$null$0(), ()Lorg/infrastructurebuilder/data/IBDataException;)());
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        try {
                            ins = src.openStream();
                            var8_9 = null;
                            localRead = new ArrayList<IBChecksumPathType>();
                            val = (IBChecksumPathType)IBDataException.cet.withReturningTranslation((ReturningTryBlock)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$null$1(java.io.InputStream ), ()Lorg/infrastructurebuilder/util/files/IBChecksumPathType;)((DefaultIBDataSource)this, (InputStream)ins));
                            localRead.add(val);
                            if (this.isExpandArchives()) {
                                localRead.addAll(wget.expand(this.targetPath, val, Optional.of(src.toExternalForm())));
                            }
                            if (ins == null) break;
                            if (var8_9 == null) ** GOTO lbl50
                            try {
                                ins.close();
                            }
                            catch (Throwable var9_11) {
                                var8_9.addSuppressed(var9_11);
                            }
                            break;
lbl50:
                            // 1 sources

                            ins.close();
                            ** break;
                            catch (Throwable var9_12) {
                                try {
                                    var8_9 = var9_12;
                                    throw var9_12;
                                }
                                catch (Throwable var10_13) {
                                    if (ins != null) {
                                        if (var8_9 != null) {
                                            try {
                                                ins.close();
                                            }
                                            catch (Throwable var11_14) {
                                                var8_9.addSuppressed(var11_14);
                                            }
                                        } else {
                                            ins.close();
                                        }
                                    }
                                    throw var10_13;
lbl67:
                                    // 1 sources

                                    break;
                                }
                            }
                        }
                        catch (IOException e) {
                            throw new IBDataException((Throwable)e);
                        }
                    }
                    default: {
                        throw new IBDataException("Default processor cannot handle protocol " + this.source);
                    }
                }
                this.read = localRead;
            }
            return this.read;
        }

        private /* synthetic */ IBChecksumPathType lambda$null$1(InputStream ins) throws Exception {
            return DefaultIBChecksumPathType.copyToDeletedOnExitTempChecksumAndPath((Path)this.targetPath, (String)"IBDataTemp_", (String)".ibdata", (InputStream)ins);
        }

        private static /* synthetic */ IBDataException lambda$null$0() {
            return new IBDataException("Could not read ");
        }
    }
}

